<?php
// Set default values
$widget = $widget ?? null;
$tours_list = $tours_list ?? [];
$form_action = $form_action ?? '';
$back_url = $back_url ?? '';
$show_form_actions = $show_form_actions ?? true;
$use_form_wrapper = $use_form_wrapper ?? false;
$csrf_token = $csrf_token ?? null;

// Convert tours list to options array for multiselect
$toursOptions = [];
if (!empty($tours_list)) {
    foreach ($tours_list as $tour) {
        // Handle both array and object formats
        $tour_id = is_array($tour) ? ($tour['id'] ?? '') : ($tour->id ?? '');
        $tour_title = is_array($tour) ? ($tour['title'] ?? '') : ($tour->title ?? '');
        $tour_description = is_array($tour) ? ($tour['description'] ?? '') : ($tour->description ?? '');
        
        // Create option text with description if available
        $option_text = $tour_title;
        if (!empty($tour_description)) {
            $option_text .= ' - ' . $tour_description;
        }
        
        $toursOptions[$tour_id] = $option_text;
    }
}

// Convert widget object to array if needed
$widgetData = [];
if ($widget) {
    $widgetData = is_array($widget) ? $widget : (array)$widget;
}
?>

<?php if ($use_form_wrapper): ?>
<form action="<?= TourGuide\TourGuideUtils::escapeHtml($form_action) ?>" method="post" class="tour-guide-widget-form">
<?php endif; ?>

    <?php if ($csrf_token): ?>
    <input type="hidden" name="<?= $csrf_token['name'] ?? 'csrf_token' ?>" value="<?= TourGuide\TourGuideUtils::escapeHtml($csrf_token['value'] ?? $csrf_token) ?>">
    <?php endif; ?>

    <?= TourGuide\Widgets\TourGuideWidgetUtils::renderWidgetForm($widgetData, $toursOptions) ?>

    <?php if ($show_form_actions): ?>
    <!-- Form Actions -->
    <div class="tour-guide-form-actions">
        <button type="submit" class="btn btn-primary">
            <?= $widget ? tourGuideHelper()->translate('tour_guide_update_widget') : tourGuideHelper()->translate('tour_guide_create_widget') ?>
        </button>
        
        <?php if (isset($back_url) && !empty($back_url)): ?>
        <a href="<?= TourGuide\TourGuideUtils::escapeHtml($back_url) ?>" class="btn btn-secondary">
            <?= tourGuideHelper()->translate('tour_guide_cancel') ?>
        </a>
        <?php endif; ?>
    </div>
    <?php endif; ?>

<?php if ($use_form_wrapper): ?>
</form>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle tour selection based on widget type
    var typeSelect = document.getElementById('<?= TourGuide\Widgets\TourGuideWidgetUtils::WIDGET_FORM_FIELD_PREFIX ?>[type]');
    var tourSection = document.querySelector('.tour-selection-section');

    function toggleTourSelection() {
        if (typeSelect && tourSection) {
            var isSetupWidget = typeSelect.value === 'setup';
            tourSection.style.display = isSetupWidget ? 'none' : 'block';
        }
    }

    if (typeSelect) {
        typeSelect.addEventListener('change', toggleTourSelection);
        toggleTourSelection(); // Initial state
    }
});
</script>