<?php defined('TOUR_GUIDE_DIR') or exit('No direct script access allowed'); ?>

<script>
"use strict";

// Set up global configuration similar to init files
window.TOUR_GUIDE_CONFIG = {
    useTooltip: true,
    notifier: function(type, message) {
        if (typeof console !== 'undefined') {
            console.log('Tour Guide: ' + type + ' - ' + message);
        }
    },
    extraPostData: {},
    context: '<?= $context; ?>',
    userAjaxUrl: '<?= $apiUrl; ?>/'
};



<?php if ($context === 'setup' && !empty($setupTemplatesContent)) : ?>
// === Setup Widget Templates (HTML) ===
// Create temporary container for setup templates
var tempDiv = document.createElement('div');
tempDiv.innerHTML = <?= json_encode($setupTemplatesContent, JSON_UNESCAPED_UNICODE); ?>;

// Append all template elements to document body
while (tempDiv.firstChild) {
    document.body.appendChild(tempDiv.firstChild);
}
<?php endif; ?>


// === Include Common Script Content from TourGuideUIHelper::init() ===
<?= $commonScriptContent; ?>

    (function() {

        // Check if already initialized
        if (window.TOUR_GUIDE_WIDGET_INITIALIZED) {
            return;
        }
        window.TOUR_GUIDE_WIDGET_INITIALIZED = true;

        // Widget-specific configuration
        window.TOUR_GUIDE_WIDGET_CONFIG = <?= json_encode($widgetConfig, JSON_UNESCAPED_UNICODE); ?>;


        var TourGuideWidget = {
            config: <?= json_encode($widgetConfig, JSON_UNESCAPED_UNICODE); ?>,
            baseUrl: '<?= $baseUrl; ?>',
            assetUrl: '<?= $assetUrl; ?>',
            apiUrl: '<?= $apiUrl; ?>',
            cssLoaded: false,
            jsLoaded: false,

            init: function() {
                var self = this;
                this.loadCSS(function() {
                    self.loadCore();
                });
            },

            loadCSS: function(callback) {
                var self = this;
                if (this.cssLoaded || document.getElementById('tour-guide-widget-css')) {
                    if (callback) callback();
                    return;
                }

                var link = document.createElement('link');
                link.id = 'tour-guide-widget-css';
                link.rel = 'stylesheet';
                link.type = 'text/css';
                link.href = this.assetUrl + 'tour-guide.min.css';
                link.onload = function() {
                    self.cssLoaded = true;
                    if (callback) callback();
                };
                link.onerror = function() {
                    console.error('Failed to load Tour Guide CSS');
                    if (callback) callback();
                };
                document.head.appendChild(link);
            },

            loadCore: function() {
                var self = this;
                if (this.jsLoaded || typeof window.tourGuideBuilderInit !== 'undefined') {
                    this.initWidget();
                    return;
                }

                var script = document.createElement('script');
                script.type = 'text/javascript';
                script.src = this.assetUrl + 'tour-guide.min.js';
                script.onload = function() {
                    self.jsLoaded = true;
                    self.initWidget();
                };
                script.onerror = function() {
                    console.error('Failed to load Tour Guide JS');
                };
                document.head.appendChild(script);
            },

            initWidget: function() {
                try {
                    // Initialize tour guide builder similar to TourGuideUIHelper::init()
                    if (typeof window.tourGuideBuilderInit === 'function') {
                        window.tourGuideBuilderInit(window.TOUR_GUIDE_CONFIG);
                    }

                    // Log successful initialization
                    this.logEvent('init_success');

                } catch (error) {
                    console.error('Tour Guide Widget initialization failed:', error);
                    this.logEvent('init_error', {
                        error: error.message
                    });
                }
            },

            logEvent: function(eventType, data) {
                try {
                    data = data || {};
                    data.widget_id = this.config.widget_id;
                    data.event_type = eventType;
                    data.domain = window.location.hostname;
                    data.page_url = window.location.href;
                    data.timestamp = new Date().toISOString();

                    // Send analytics (non-blocking)
                    var img = new Image();
                    img.src = this.apiUrl + '/analytics?' + this.serialize(data);
                } catch (error) {
                    // Silently handle analytics errors
                }
            },

            serialize: function(obj) {
                return Object.keys(obj).map(function(key) {
                    return encodeURIComponent(key) + '=' + encodeURIComponent(obj[key] || '');
                }).join('&');
            }
        };

        // Initialize when DOM is ready
        function initWhenReady() {
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    TourGuideWidget.init();
                });
            } else {
                // DOM already loaded
                setTimeout(function() {
                    TourGuideWidget.init();
                }, 100);
            }
        }

        initWhenReady();

    })();
</script>