<?php

namespace TourGuide;

class TourGuideInstaller
{
    static function install()
    {
        $TG = tourGuideHelper()->dbInstance();
        $dbPrefix = $TG->getPrefix();

        // Add tour guide table
        $table = $dbPrefix . 'tour_guide';
        $query = "CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `title` varchar(150) NOT NULL,
            `description` text,
            `priority` INT NOT NULL DEFAULT 1,
            `status` varchar(50) DEFAULT 'active',
            `steps` MEDIUMTEXT,
            `settings` text,
            `steps_translations` MEDIUMTEXT,
            `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET='" . $TG->getCharset() . "' COLLATE='" . $TG->getCollation() . "';";
        $TG->runRawQuery($query);

        // Add meta table for storing any other data
        $table = $dbPrefix . 'tour_guide_metadata';
        $query = "CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(150) NOT NULL UNIQUE,
            `value` MEDIUMTEXT,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB DEFAULT CHARSET='" . $TG->getCharset() . "'  COLLATE='" . $TG->getCollation() . "';";
        $TG->runRawQuery($query);

        // Add widgets table for embeddable widgets
        $table = $dbPrefix . 'tour_guide_widgets';
        $query = "CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `widget_id` VARCHAR(255) NOT NULL UNIQUE,
            `title` VARCHAR(255) NOT NULL,
            `description` TEXT,
            `type` ENUM('setup', 'player') NOT NULL DEFAULT 'player',
            `status` ENUM('active', 'inactive') NOT NULL DEFAULT 'active',
            `selected_tours` TEXT,
            `settings` TEXT,
            `domain_whitelist` TEXT,
            `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            INDEX `idx_widget_id` (`widget_id`),
            INDEX `idx_type` (`type`),
            INDEX `idx_status` (`status`)
          ) ENGINE=InnoDB DEFAULT CHARSET='" . $TG->getCharset() . "'  COLLATE='" . $TG->getCollation() . "';";
        $TG->runRawQuery($query);

        // Add widget analytics table for tracking usage
        $table = $dbPrefix . 'tour_guide_widget_analytics';
        $query = "CREATE TABLE IF NOT EXISTS `{$table}` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `widget_id` VARCHAR(255) NOT NULL,
            `domain` VARCHAR(255),
            `page_url` TEXT,
            `user_agent` TEXT,
            `ip_address` VARCHAR(45),
            `event_type` VARCHAR(50),
            `tour_id` INT(11),
            `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`),
            INDEX `idx_widget_id` (`widget_id`),
            INDEX `idx_event_type` (`event_type`),
            INDEX `idx_created_at` (`created_at`)
          ) ENGINE=InnoDB DEFAULT CHARSET='" . $TG->getCharset() . "'  COLLATE='" . $TG->getCollation() . "';";
        $TG->runRawQuery($query);
    }

    static function uninstall()
    {
        $TG = tourGuideHelper()->dbInstance();
        $dbPrefix = $TG->getPrefix();

        // Drop widget analytics first (has foreign key reference)
        $table = $dbPrefix . 'tour_guide_widget_analytics';
        $query = "DROP TABLE IF EXISTS `$table`;";
        $TG->runRawQuery($query);

        // Drop widgets table
        $table = $dbPrefix . 'tour_guide_widgets';
        $query = "DROP TABLE IF EXISTS `$table`;";
        $TG->runRawQuery($query);

        $table = $dbPrefix . 'tour_guide';
        $query = "DROP TABLE IF EXISTS `$table`;";
        $TG->runRawQuery($query);

        $table = $dbPrefix . 'tour_guide_metadata';
        $query = "DROP TABLE IF EXISTS `$table`;";
        $TG->runRawQuery($query);
    }
}