<?php
defined('BASEPATH') or exit('No direct script access allowed');
$hasPermissionView   = has_permission('si_greetings_manager', '', 'view');
$hasPermissionEdit   = has_permission('si_greetings_manager', '', 'edit');
$hasPermissionDelete = has_permission('si_greetings_manager', '', 'delete');
$hasPermissionCreate = has_permission('si_greetings_manager', '', 'create');

$send = '<i class="fa fa-check text-success"></i>';
$not_send = '<i class="fa fa-close text-danger"></i>';

$aColumns = [
	db_prefix() . 'si_greetings_manager_schedule.id as id',
	db_prefix() . 'si_greetings_manager_schedule.name as schedule_name',
	db_prefix().'customfields.name as custom_field_name',
	'filter_by',
	'content',
	'send_sms',
	'send_email',
	'schedule_days',
	'schedule_hour',
	'staff_id',
	'dateadded',
	'last_executed',
	];
$sIndexColumn = 'id';
$sTable       = db_prefix().'si_greetings_manager_schedule';
$join = [
	'JOIN '.db_prefix().'staff ON '.db_prefix().'staff.staffid = '.db_prefix().'si_greetings_manager_schedule.staff_id',
	'LEFT JOIN '.db_prefix().'customfields ON '.db_prefix().'customfields.id = '.db_prefix().'si_greetings_manager_schedule.cf_id',
];
$where  = [];
$filter = [];
if(!$hasPermissionView) {
	array_push($where, ' AND staff_id=' . get_staff_user_id());
}

if (count($filter) > 0) {
	array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
}
$aColumns = hooks()->apply_filters('si_greetings_manager_schedule_table_sql_columns', $aColumns);
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
	'CONCAT(firstname," ",lastname) as staff_name',
	'cf_id',
]);
$output  = $result['output'];
$rResult = $result['rResult'];
foreach ($rResult as $aRow) {

	$row = [];
	
	$row[] = '<a href="#" onclick="view_schedule_modal(' . $aRow['id'] . ');return false;">' . $aRow['id'] . '</a>';
	
	$schedule = '<a href="#" onclick="view_schedule_modal(' . $aRow['id'] . ');return false;">' . $aRow['schedule_name'] . '</a>';
	$schedule .= '<div class="row-options">';
	$schedule .= '<a href="#" onclick="view_schedule_modal(' . $aRow['id'] . ');return false;">' . _l('view') . '</a>';
	if ($hasPermissionEdit) {
		$schedule .= ' | <a href="#" onclick="edit_schedule_modal(' . $aRow['id'] . ');return false;">' . _l('edit') . '</a>';
	}
	if ($hasPermissionDelete) {
		$schedule .= ' | <a href="#" class="text-danger _delete si_greetings_manager_schedule_delete" data-id="'.$aRow['id'].'">' .
		 _l('delete') . '</a>';
	}
	$schedule .= '</div>';
	
	$row[] = $schedule;
	
	$row[] = $aRow['custom_field_name'];
	
	$filter_by = _l('customer_contacts');
	if($aRow['filter_by']=='staff') $filter_by = _l('staff');
	
	$row[] = $filter_by;
	
	$row[] = mb_substr($aRow['content'] ?? '',0,100).(strlen($aRow['content'] ?? '') > 100 ? "..." : "");

	$row[] = ($aRow['send_sms'] ? $send : $not_send);

	$row[] = ($aRow['send_email'] ? $send : $not_send);
	
	$row[] = $aRow['schedule_days'].' '._l('days');
	
	$row[] = date('h A',strtotime('01-01-1970 '.$aRow['schedule_hour'].":00:00"));
	
	$assignedOutput = '';
	if ($aRow['staff_id'] != 0) {
		$full_name = $aRow['staff_name'];
		$assignedOutput = '<a data-toggle="tooltip" data-title="' . $full_name . '" href="' . admin_url('profile/' . $aRow['staff_id']) . '">' . staff_profile_image($aRow['staff_id'], [
			'staff-profile-image-small',
			]) . '</a>';
		$assignedOutput .= '<span class="hide">' . $full_name . '</span>';
	}
	
	$row[] = $assignedOutput;
	
	$row[] = _d($aRow['dateadded']);
	
	$row[] = _d($aRow['last_executed']);
	
	$row['DT_RowClass'] = 'has-row-options';
	
	$row = hooks()->apply_filters('si_greetings_manager_schedule_table_row_data', $row, $aRow);
	
	$output['aaData'][] = $row;
}