<?php
defined('BASEPATH') or exit('No direct script access allowed');

$hasPermissionView   = has_permission('si_greetings_manager', '', 'view');

$sent = '<i class="fa fa-check text-success"></i>';
$not_sent = '<i class="fa fa-close text-danger"></i>';

$aColumns = [
	si_gm_rel_name_select_query() . ' as name',
	db_prefix() . 'si_greetings_manager_schedule.name as schedule_name',
	'filter_by',
	'sent_sms',
	'sent_email',
	'comment',
	db_prefix() . 'si_greetings_manager_schedule_rel.dateadded as dateadded',
	];
$sIndexColumn = 'schedule_id';
$sTable       = db_prefix().'si_greetings_manager_schedule_rel';
$join = [
	'LEFT JOIN ' . db_prefix() . 'si_greetings_manager_schedule ON ' . db_prefix() . 'si_greetings_manager_schedule.id = ' . db_prefix() . 'si_greetings_manager_schedule_rel.schedule_id',
];
$where  = [];
$filter = [];
if(!$hasPermissionView) {
	array_push($where, ' AND ' . db_prefix() . 'si_greetings_manager_schedule.staff_id=' . get_staff_user_id());
}

if (count($filter) > 0) {
	array_push($where, 'AND (' . prepare_dt_filter($filter) . ')');
}
$aColumns = hooks()->apply_filters('si_greetings_manager_logs_table_sql_columns', $aColumns);
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, []);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {

	$row = [];
	
	$row[] = $aRow['name'];
	
	$row[] = $aRow['schedule_name'];
	
	$filter_by = _l('customer_contacts');
	if($aRow['filter_by']=='staff') $filter_by = _l('staff');
	
	$row[] = $filter_by;

	$row[] = ($aRow['sent_sms'] ? $sent : $not_sent);

	$row[] = ($aRow['sent_email'] ? $sent : $not_sent);

	$row[] = $aRow['comment'];
	
	$row[] = _d($aRow['dateadded']);
	
	$row['DT_RowClass'] = 'has-row-options';
	
	$row = hooks()->apply_filters('si_greetings_manager_logs_table_row_data', $row, $aRow);
	
	$output['aaData'][] = $row;
}