<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body">
						<h4 class="pull-left"><?php echo htmlspecialchars($title); ?></h4>
						<?php if (has_permission('si_greetings_manager', '', 'create')) {?>
						<?php echo form_open_multipart($this->uri->uri_string(),array('id'=>'si_greetings_manager_schedule_form')); ?>
						<div class="pull-right">
							<div class="btn-group">
								<button type="button" class="btn btn-info" onclick="slideToggle('.si-greetings-manager-add-schedule'); return false;">
									<?php echo _l('si_gm_schedule_add')?>
								</button>
							</div>
						</div>		
						<div class="clearfix"></div>
						<div class="si-greetings-manager-add-schedule hide">
							<hr />
							<div class="row" id="si_greetings_manager_send_wrapper" data-wait-text="<?php echo '<i class=\'fa fa-spinner fa-pulse\'></i> '._l('wait_text'); ?>" data-original-text="<?php echo _l('save'); ?>">
								<div class="col-md-12">
									<p class="text-info"><?php echo _l('si_gm_schedule_send_title_info');?></p>
								</div>
								<div class="col-md-4 border-right">
									<div class="col-md-12">
										<?php echo render_input('name','si_gm_name','','text',array('maxlength'=>100));?>
									</div>
									<div class="col-md-12 mbot15">
										<label><?php echo _l('si_gm_send_to');?></label><br/>
										<div class="radio radio-inline radio-primary">
											<input type="radio" id="filter_by_1" name="filter_by" value="contacts" checked>
											<label for="filter_by_1"><?php echo _l('client'). ' '._l('customer_contacts'); ?></label>
										</div>
										<div class="radio radio-inline radio-primary">
											<input type="radio" id="filter_by_2" name="filter_by" value="staff">
											<label for="filter_by_2"><?php echo _l('staff_members'); ?></label>
										</div>
									</div>
									<div class="col-md-12">
										<span class="pull-left fa fa-question-circle" data-toggle="tooltip" title="<?php echo  _l('si_gm_custom_field_info'); ?>"> </span><a class="pull-right <?php echo (!is_admin() ? ' hide' : '') ?>" href='<?php echo admin_url('custom_fields')?>' data-toggle="tooltip" data-title="<?php echo _l('new_custom_field')?>"><i class="fa fa-plus"></i></a>
										<?php echo render_select('cf_id',$contacts_cf,array('id','name'),'custom_field','',array('required'=>true)); ?>
									</div>
									<div class="col-md-12">
										<?php echo render_input('schedule_days','si_gm_schedule_days',0,'number',array('data-toggle'=>'tooltip','data-title'=>_l('si_gm_schedule_days_info'),'min'=>0,'max'=>100)); ?>
									</div>
									<div class="col-md-12">
										<?php echo render_input('schedule_hour','si_gm_schedule_hour',12,'number',array('data-toggle'=>'tooltip','data-title'=>_l('hour_of_day_perform_auto_operations').". "._l('hour_of_day_perform_auto_operations_format'),'min'=>0,'max'=>23)); ?>
									</div>
								</div>
								<div class="col-md-8">	
									<div class="col-md-12">
										<label><?php echo _l('send');?></label> 
										<div class="checkbox checkbox-inline checkbox-primary">
											<input type="checkbox" id="si_send_sms" name="send_sms" value="1" checked>
											<label for="send_sms"><?php echo 'SMS'; ?></label>
										</div>
										<div class="checkbox checkbox-inline checkbox-primary">
											<input type="checkbox" id="si_send_email" name="send_email" value="1">
											<label for="send_email"><?php echo _l('leads_dt_email'); ?></label>
										</div>
									</div>	
									<div class="col-md-12">
										<a href="#" onclick="slideToggle('#si_greetings_manager_custom_merge_fields'); return false;" class="pull-right"><small><?php echo _l('available_merge_fields')?></small></a>
										<?php echo render_textarea('sms_content','si_gm_text','',array('rows'=>6));?>
										<?php if($merge_fields != ''){?>
										<div id="si_greetings_manager_custom_merge_fields" class="hide mbot10">
											<?php if(is_array($merge_fields)){
													foreach($merge_fields as $key=>$mf){
														echo "<div id='div_merge_field_".$key."' class='div_merge_field'>".$mf."</div>";
													}
												}
												else		
													echo ($merge_fields);
											?>
										</div>
										<?php }?>
										<div id="div_dlt_template">
											<?php 
											$trigger_name = SI_GREETINGS_MANAGER_MODULE_NAME.'_custom_sms';
											$trigger_opts = [];
											hooks()->do_action('after_sms_trigger_textarea_content', ['name' => $trigger_name, 'options' => $trigger_opts]);?>
										</div>
									</div>
									<div class="col-md-12">
										<a href="#" onclick="slideToggle('#si_greetings_manager_custom_merge_fields'); return false;" class="pull-right"><small><?php echo _l('available_merge_fields')?></small></a>
										<?php echo render_input('email_subject','send_file_subject','','text',array('maxlength'=>250));?>
										<?php echo render_textarea('email_template_custom', 'email_template', '', [], [], '', 'tinymce-si')?>
										<span class="text-info pull-right">(<?php echo SI_GREETINGS_MANAGER_ACCEPT_FILE_TYPES;?>)</span>
										<?php echo render_input('file','si_gm_attachment','','file',array('accept'=>SI_GREETINGS_MANAGER_ACCEPT_FILE_TYPES));?>
									</div>
								</div>	
								<div class="col-md-12 text-center">
									<hr class="hr-10" />
									<button id="si_greetings_manager_send" type="submit" class="btn btn-info mleft4"><?php echo _l('save'); ?></button>
									<button id="si_greetings_manager_clear" type="reset" class="btn btn-default mleft4"><?php echo _l('clear'); ?></a>
								</div>
							</div>
						</div>
						<?php echo form_close(); ?>
						<?php }?>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body panel-table-full">
						<?php $this->load->view('table_html'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="si_greetings_manager_view_schedule_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="myModalLabel">
					<span><?php echo _l('si_greetings_manager_menu') ." - ". _l('si_greetings_manager_schedule_submenu'); ?></span>
				</h4>
			</div>
			<div class="modal-body email-template" data-editor-id=".tinymce-si-edit">
				<div id="div_greetings_view_schedule"></div>
			</div>
			<div class="modal-footer">
				<button id="si_greetings_manager_btn_for_edit" type="button" class="btn btn-info"><?php echo _l('submit'); ?></button>
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
			</div>
		</div>
	</div>
</div>
<?php init_tail(); ?>
</body>
</html>	
<script>
	var select_sms_or_email = '<?php echo _l('si_gm_select_atleast_one')?>';
	var accept_file_types = '<?php echo str_replace(',','|',str_replace('.','',SI_GREETINGS_MANAGER_ACCEPT_FILE_TYPES))?>';
</script>	
</script>	
<script src="<?php echo module_dir_url('si_greetings_manager','assets/js/si_greetings_manager_schedule.js'); ?>"></script>