<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body">
						<h4 class="pull-left"><?php echo htmlspecialchars($title); ?></h4>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body panel-table-full">
						<?php $table_data = [
							_l('name'),
							_l('si_gm_name'),
							_l('si_gm_sent_to'),
							'SMS',
							_l('leads_dt_email'),
							_l('comment_string'),
							[
								'name' => _l('view_date'),
                                'th_attrs' => array('class'=>'date-created','id'=>'th-date-created'),
							],
						];
						$table_data = hooks()->apply_filters('si_greetings_manager_logs_table_columns', $table_data);
						render_datatable($table_data, 'si-greetings-manager-logs', ['number-index-1'], [
							'data-last-order-identifier'=> 'si-greetings-manager-logs',
							'data-default-order'		=> get_table_last_order('si-greetings-manager-logs'),
						]); 
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php init_tail(); ?>
</body>
</html>	
<script src="<?php echo module_dir_url('si_greetings_manager','assets/js/si_greetings_manager_schedule.js'); ?>"></script>