<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: SI Greetings Manager
Description: Module will allow to send greetings SMS and emails to Clients or Staffs on their special days like Birthday and Anniversary.
Version: 1.0.4
Requires at least: 2.3.*
Author: Sejal Infotech
Author URI: https://codecanyon.net/user/sejalinfotech/portfolio
*/

define('SI_GREETINGS_MANAGER_MODULE_NAME', 'si_greetings_manager');
define('SI_GREETINGS_MANAGER_VALIDATION_URL','http://www.sejalinfotech.com/perfex_validation/validate.php');
define('SI_GREETINGS_MANAGER_KEY','c2lfZ3JlZXRpbmdzX21hbmFnZXI=');
define('SI_GREETINGS_MANAGER_ATTACHMENTS_FOLDER', FCPATH . 'uploads/si_greetings_manager/');
define('SI_GREETINGS_MANAGER_ACCEPT_FILE_TYPES',".pdf,.jpg,.png,.jpeg");

$CI = &get_instance();

hooks()->add_filter('module_'.SI_GREETINGS_MANAGER_MODULE_NAME.'_action_links', 'module_si_greetings_manager_action_links');
hooks()->add_action('admin_init', 'si_greetings_manager_admin_init_hook');
hooks()->add_filter('get_upload_path_by_type','si_greetings_manager_hook_get_upload_path_by_type',1,2);
hooks()->add_action('settings_tab_footer','si_greetings_manager_hook_settings_tab_footer');#for perfex low version V2.4 
hooks()->add_action('settings_group_end','si_greetings_manager_hook_settings_tab_footer');#for perfex high version V2.8.4
hooks()->add_filter('calendar_data', 'si_greetings_manager_hook_calendar_data', 10, 2);
hooks()->add_action('after_calendar_filters', 'si_greetings_manager_hook_after_calendar_filters');
hooks()->add_action('after_cron_run', 'si_greetings_manager_hook_after_cron_run');

/**
 * Add additional settings for this module in the module list area
 * @param  array $actions current actions
 * @return array
 */
function module_si_greetings_manager_action_links($actions)
{
	$actions[] = '<a href="' . admin_url('settings?group=si_greetings_manager_settings') . '">' . _l('settings') . '</a>';
	return $actions;
}

/**
* Load the module model
*/
$CI->load->model(SI_GREETINGS_MANAGER_MODULE_NAME . '/si_greetings_manager_model');

/**
* Load the module helper
*/
$CI->load->helper(SI_GREETINGS_MANAGER_MODULE_NAME . '/si_greetings_manager');

/**
* Register activation module hook
*/
register_activation_hook(SI_GREETINGS_MANAGER_MODULE_NAME, 'si_greetings_manager_activation_hook');

function si_greetings_manager_activation_hook()
{
	$CI = &get_instance();
	require_once(__DIR__ . '/install.php');
}

/**
 * Register Uninstall module hook
 */
register_uninstall_hook(SI_GREETINGS_MANAGER_MODULE_NAME, 'si_greetings_manager_uninstall_hook');

function si_greetings_manager_uninstall_hook()
{
    $CI = &get_instance();
	require_once(__DIR__ . '/uninstall.php');
}

/**
* Register language files, must be registered if the module is using languages
*/
register_language_files(SI_GREETINGS_MANAGER_MODULE_NAME, [SI_GREETINGS_MANAGER_MODULE_NAME]);

/**
*	Admin Init Hook for module
*/
function si_greetings_manager_admin_init_hook()
{
	$CI = &get_instance();
	$capabilities = [];
	$capabilities['capabilities'] = [
		'view_own' => _l('permission_view_own'),
		'view'     => _l('permission_view') . '(' . _l('permission_global') . ')',
		'create'   => _l('permission_create'),
		'edit'     => _l('permission_edit'),
		'delete'   => _l('permission_delete'),
	];
	register_staff_capabilities('si_greetings_manager', $capabilities, _l('si_greetings_manager'));
	if(get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activated') && get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activation_code')!=''){
		si_greetings_manager_mapping();
		if (is_admin() || has_permission('si_greetings_manager', '', 'view') || has_permission('si_greetings_manager', '', 'view_own')) {
			$CI->app_menu->add_sidebar_menu_item('si_greetings_manager_menu', [
				'collapse' => true,
				'icon'     => 'fa fa-envelope',
				'name'     => _l('si_greetings_manager_menu'),
				'position' => 35,
			]);
			$CI->app_menu->add_sidebar_children_item('si_greetings_manager_menu', [
				'slug'     => 'si-greetings-manager-schedule-menu',
				'name'     => _l('si_greetings_manager_schedule_submenu'),
				'href'     => admin_url('si_greetings_manager'),
				'position' => 1,
			]);
			$CI->app_menu->add_sidebar_children_item('si_greetings_manager_menu', [
				'slug'     => 'si-greetings-manager-log-menu',
				'name'     => _l('si_greetings_manager_log_submenu'),
				'href'     => admin_url('si_greetings_manager/logs'),
				'position' => 2,
			]);
		}
	}
	/**  Add Tab In Settings Tab of Setup **/
	if (is_admin() || has_permission('settings', '', 'view')) {
		$perfex_version = (int)$CI->app->get_current_db_version();
	    $slug = 'si_greetings_manager_settings';
	    $tab = [
			'name'     => _l('si_greetings_manager_settings'),
			'view'     => 'si_greetings_manager/si_greetings_manager_settings',
			'icon'     => 'fa fa-gears',
			'position' => 100,
		];
		if($perfex_version >= 320)
	        $CI->app->add_settings_section_child('other', $slug, $tab);
	    else
		    $CI->app_tabs->add_settings_tab($slug, $tab);
	}
	si_greetings_manager_init(SI_GREETINGS_MANAGER_MODULE_NAME);
}

/**
 * Hook to add path of uploads for hrm documents
 */
function si_greetings_manager_hook_get_upload_path_by_type($path, $type)
{
	if($type=='si_greetings_manager'){
			$path = SI_GREETINGS_MANAGER_ATTACHMENTS_FOLDER;
	}
	return $path;
}

function si_greetings_manager_hook_settings_tab_footer($tab)
{
	$slug = isset($tab['id']) ? $tab['id'] : $tab['slug'];//slug is deprecated from Perfex Version 3.2
	if($slug=='si_greetings_manager_settings' && (get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activation_code')=='' || !get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activated'))){
		echo '<script src="'.module_dir_url('si_greetings_manager','assets/js/si_greetings_manager_settings_footer.js').'"></script>';
	}
}

/** 
 * Hook to display Greetings data on Calendar of Perfex
 */
function si_greetings_manager_hook_calendar_data($data, $config)
{
	$CI = &get_instance();
	$_POST = $_REQUEST; //for Perfex Version > 2.8.2 (before that calendar data was get as POST, now get as GET)
	$filters = $CI->input->post();
	$ff = false;
	if ($filters) {
		// excluded calendar_filters from post
		$ff = (count($filters) > 1 && isset($filters['calendar_filters']) ? true : false);
	}
	if (get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_show_on_calendar') == 1 && !$ff || $ff && array_key_exists('si_greetings', $filters)) {
		$greeting_data = $CI->si_greetings_manager_model->get_greetings_calendar_data($config['start'], $config['end']);
		if(!empty($greeting_data))
			$data = array_merge($data,$greeting_data);
		}
	return $data;
}

/**
 * Hook to add filter for calender
 */
function si_greetings_manager_hook_after_calendar_filters()
{
	$CI = &get_instance();
	if(get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_show_on_calendar') == 1){ ?>
		<div class="checkbox">
			<input type="checkbox" value="1" name="si_greetings" id="cf_si_greetings"<?php if($CI->input->post('si_greetings')){echo ' checked';} ?>>
			<label for="cf_si_greetings"><?php echo _l('si_gm_greetings'); ?></label>
		</div>
	<?php }
}

hooks()->add_action('pre_deactivate_module', SI_GREETINGS_MANAGER_MODULE_NAME.'_deregister');
function si_greetings_manager_deregister($module_name)
{
    if (SI_GREETINGS_MANAGER_MODULE_NAME == $module_name['system_name']) {
        delete_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activated');
        delete_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_varification_token');
    }
}

/**
 * Hook to Register cronjob to send greeetings via sms and email templates 
 *
 * @return void
 */
function si_greetings_manager_hook_after_cron_run($manually)
{
	if ($manually === true) {
		return;
	}
	send_si_greetings_manager_cron_run();
	return;
}