<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Si_greetings_manager_model extends App_Model
{
	public function __construct()
	{
		parent::__construct();
	}
	
	public function get_schedule($id,$where = [])
	{
		$this->db->select(db_prefix() . 'si_greetings_manager_schedule.*,'.db_prefix() . 'customfields.name as custom_field_name');
		$this->db->where(db_prefix() . 'si_greetings_manager_schedule.id', $id);
		if ((is_array($where) && count($where) > 0) || (is_string($where) && $where != '')) {
			$this->db->where($where);
		}
		$this->db->join(db_prefix() . 'customfields', db_prefix() . 'customfields.id = '. db_prefix() . 'si_greetings_manager_schedule.cf_id');
		$schedule = $this->db->get(db_prefix() . 'si_greetings_manager_schedule')->row();

		if ($schedule) {
			$schedule->attachment            = '';
			$schedule->filetype              = '';
			$schedule->attachment_added_from = 0;

			$this->db->where('rel_id', $id);
			$this->db->where('rel_type', 'si_greetings_manager');
			$file = $this->db->get(db_prefix() . 'files')->row();

			if ($file) {
				$schedule->attachment            = $file->file_name;
				$schedule->filetype              = $file->filetype;
				$schedule->attachment_added_from = $file->staffid;
			}
		}
		return $schedule;
	}
	
	public function get_schedules($hour_now, $today_date)
	{
		$this->db->where('schedule_hour',$hour_now);
		$this->db->where('(last_executed < "'. $today_date.'" OR last_executed IS NULL)');
		$this->db->order_by('id','ASC');
		return $this->db->get(db_prefix() . 'si_greetings_manager_schedule')->result_array();
	}
	
	public function add_schedule($data)
	{
		$this->db->insert(db_prefix() . 'si_greetings_manager_schedule', $data);
		$insert_id = $this->db->insert_id();
		if ($insert_id) {
			if(isset($data['send_email']) && $data['send_email'] == 1 && (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK)){
				$attachment_id = handle_si_greetings_manager_attachments($insert_id);
				$this->update_schedule($insert_id,array('email_attachment_id'=>$attachment_id));
			}

			log_activity('Greetings Manager Schedule Added [Id:' . $insert_id . ']');
			return $insert_id;
		}
		return false;
	}
	
	public function update_schedule($schedule_id,$data)
	{
		$via_cron = false;
		if(isset($data['cron'])){
			$via_cron = true;
			unset($data['cron']);
		}

		// Check if email is enabled and attachment is uploaded. If yes, then add attachment to email.
		if(isset($data['send_email']) && $data['send_email'] == 1 && (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) && !$via_cron){
			$attachment_id = handle_si_greetings_manager_attachments($schedule_id);
			$data['email_attachment_id'] = $attachment_id;
		}
		
		if(is_staff_logged_in() && !$via_cron){
			$this->db->where('staff_id',get_staff_user_id());
		}
		$this->db->where('id',$schedule_id);
			
		$update = $this->db->update(db_prefix() . 'si_greetings_manager_schedule', $data);
		if ($update) {
			return true;
		}
		return false;
	}
	
	public function delete_schedule($id)
	{
		if (!has_permission('si_greetings_manager', '', 'view'))
			$this->db->where('staff_id', get_staff_user_id());
		
		$this->db->where('id', $id);
		$this->db->delete(db_prefix() . 'si_greetings_manager_schedule');
		
		if ($this->db->affected_rows() > 0) {
			$this->db->where('schedule_id',$id);
			$this->db->delete(db_prefix() . 'si_greetings_manager_schedule_rel');

			//delete attachment if any
			$this->db->where('rel_id', $id);
            $this->db->where('rel_type', 'si_greetings_manager');
            $attachments = $this->db->get(db_prefix() . 'files')->result_array();
			if(!empty($attachments)){
				foreach ($attachments as $attachment) {
					$this->delete_attachment($attachment['id']);
				}
			}
			return true;
		}
		return false;
	}

	/**
     * Delete schedule attachment uploaded by staff
     * @param  mixed $id attachment id
     * @return boolean
     */
    public function delete_attachment($id)
    {
        $this->db->where('id', $id);
        $attachment = $this->db->get(db_prefix() . 'files')->row();
        $deleted    = false;
        if ($attachment) {
            if (empty($attachment->external)) {
                $relPath  = get_upload_path_by_type('si_greetings_manager') . $attachment->rel_id . '/';
                $fullPath = $relPath . $attachment->file_name;
                unlink($fullPath);
            }

            $this->db->where('id', $id);
            $this->db->delete(db_prefix() . 'files');
            if ($this->db->affected_rows() > 0) {
                $deleted = true;
               log_activity('Greetings Manager Schedule Attachment Deleted [ID: ' . $attachment->rel_id . ']');
            }

            if (is_dir(get_upload_path_by_type('si_greetings_manager') . $attachment->rel_id)) {
                // Check if no attachments left, so we can delete the folder also
                $other_attachments = list_files(get_upload_path_by_type('si_greetings_manager') . $attachment->rel_id);
                if (count($other_attachments) == 0) {
                    delete_dir(get_upload_path_by_type('si_greetings_manager') . $attachment->rel_id);
                }
            }
			if($deleted){
				$this->db->where('email_attachment_id', $id);
				$this->db->set('email_attachment_id',0);
				$this->db->update(db_prefix() . 'si_greetings_manager_schedule');
			}
        }

        return $deleted;
    }
	
	public function add_schedule_rel_ids($schedule_id,$rel_id,$comment=false,$sent_sms=0,$sent_email=0)
	{
		if(is_numeric($schedule_id) && $schedule_id > 0) {
			$_data = array('schedule_id' => $schedule_id,'rel_id'=>$rel_id,'sent_sms'=> $sent_sms,'sent_email'=> $sent_email,'dateadded' => date('Y-m-d H:i:s'));
			if($comment)
				$_data['comment'] = $comment;
			$this->db->insert(db_prefix() . 'si_greetings_manager_schedule_rel', $_data);
		}
	}

	public function get_schedule_rel_ids($schedule_id)
	{
		if(is_numeric($schedule_id)){
			$schedule = $this->get_schedule($schedule_id);
			if($schedule->filter_by == 'contacts'){
				$this->db->select(db_prefix() . 'si_greetings_manager_schedule_rel.*,CONCAT(' . db_prefix() . 'contacts.firstname," ",' . db_prefix() . 'contacts.lastname) as name');
				$this->db->join(db_prefix() . 'contacts',db_prefix().'contacts.id = '.db_prefix() .'si_greetings_manager_schedule_rel.rel_id','left');
			}elseif($schedule->filter_by == 'staff'){
				$this->db->select(db_prefix() . 'si_greetings_manager_schedule_rel.*, CONCAT(firstname," ",lastname) as name');
				$this->db->join(db_prefix() . 'staff',db_prefix().'staff.staffid = '.db_prefix() .'si_greetings_manager_schedule_rel.rel_id','left');
			}
			
			$this->db->where('schedule_id',$schedule_id);
			$this->db->order_by('dateadded','DESC');
			return $this->db->get(db_prefix() . 'si_greetings_manager_schedule_rel')->result_array();
			
		}
		return array();
	}

	/**Get greetings calendar Data */
    function get_greetings_calendar_data($start, $end, $where = '')
    {
        $is_admin                     = is_admin();
        $has_permission_greetings_view    = has_permission('si_greetings_manager', '', 'view');
        $data                         = [];

		if(!$has_permission_greetings_view && !$is_admin)
			$this->db->where('staff_id', get_staff_user_id());
		$this->db->order_by('id','ASC');
		$result = $this->db->get(db_prefix() . 'si_greetings_manager_schedule')->result_array();

		$months = $this->get_months_between($start,$end);

        if(!empty($result)){
			foreach($result as $row){
				$this->db->select('c.*,cfv.value,cfv.fieldid,cfv.relid,cf.name as custom_field_name');
				$this->db->where('cfv.fieldto',$row['filter_by']);
				$this->db->where_in('MONTH(value)',$months);
				$this->db->where('cfv.fieldid', $row['cf_id']);
				$this->db->join(db_prefix() . 'customfields as cf','`cf`.`id` = `cfv`.`fieldid`');
				if($row['filter_by'] == 'contacts')
					$this->db->join(db_prefix() . 'contacts as c','`c`.`id` = `cfv`.`relid` AND `c`.`active` = 1');
				elseif($row['filter_by'] == 'staff')
					$this->db->join(db_prefix() . 'staff as c','`c`.`staffid` = `cfv`.`relid` AND `c`.`active` = 1');

				$contacts = $this->db->get(db_prefix() . 'customfieldsvalues as cfv')->result_array();

				foreach ($contacts as $contact) {
					$type_name_showcase = '';
					if($row['filter_by'] == 'contacts'){
						$type_name_showcase =  _l('client');
					}
					elseif($row['filter_by'] == 'staff'){
						$type_name_showcase =  _l('staff') ;
					}
					$date_showcase = ' (' . _d($contact['value']) . ')';
		
					$year = date("Y",strtotime($start));
					$year = date('m',strtotime($contact['value'])) == date("m",strtotime($end)) ? date("Y",strtotime($end)) : $year;
				    $cal_data['date'] = $year . '-' . date('m-d',strtotime($contact['value']));
		
					$name             = $contact['firstname'] . ' ' . $contact['lastname'];
					$cal_data['title']    =  $contact['custom_field_name']. ' - ' . $name;
					$cal_data['color']    = '#2342e0';
					$cal_data['_tooltip'] = $contact['custom_field_name']. ' - ' . $name . ' (' . $type_name_showcase . ')' . ' - ' . $date_showcase ;

					array_push($data, $cal_data);
				}
			}
		}

        return $data;
    }

	function get_months_between($start, $end) {
		$time1  = strtotime($start);
		$time2  = strtotime($end);
		$my     = date('mY', $time2);
	 
		$months = array(date('m', $time1));
		$m      = '';
	 
		while($time1 < $time2) {
		   $time1 = strtotime((date('Y-m-d', $time1).' +15days'));
		   if(date('m', $time1) != $m) {
			  $m = date('m', $time1);
			  if(date('mY', $time1) != $my && ($time1 < $time2))
				 $months[] = date('m', $time1);
		   }
		}
	 
		$months[] = date('m', $time2);
		return $months;
	}

	//get path for documents
	function get_path($attachment_id)
	{
		$this->db->where('id', $attachment_id);
		$this->db->where('rel_type', 'si_greetings_manager');
		$file = $this->db->get(db_prefix() . 'files')->row();
		$path = get_upload_path_by_type('si_greetings_manager') . $file->rel_id . '/' . $file->file_name;
		return $path;
	}
	
	function get_do(){
        return substr(hash('sha512', base_url()), 0, 10);
    }
}