<?php
defined('BASEPATH') or exit('No direct script access allowed');

function si_greetings_manager_get_merge_fields($filter_by='')
{
	$merge_fields = array();
		
	$merge_fields['contacts'] 		= 	'{contact_firstname}, {contact_lastname}, {contact_phonenumber}, {contact_email}, {client_company},'.
										' {client_country}, {client_city}, {client_zip}, {client_state}, {client_address}';
		
	$merge_fields['staff'] 		= '{staff_firstname}, {staff_lastname}, {staff_email}';
	
	if($filter_by!='' && isset($merge_fields[$filter_by]))
		return $merge_fields[$filter_by];
	else
		return $merge_fields;
}

function send_si_greetings_manager_cron_run()
{

	$CI = &get_instance();
	$now = time();
	$today_date = date('Y-m-d 00:00:00',$now);
	$hour_now = date('G');
	$result = $CI->si_greetings_manager_model->get_schedules($hour_now,$today_date);
	
	$count=0;
	if(!empty($result)){
		foreach($result as $row){
			$custom_trigger_name = 'si_greetings_manager_custom_sms';
			$filter_by = $row['filter_by'];
			$cf_id = $row['cf_id'];
			$sms_message = $row['content'];
			$email_subject = $row['email_subject'];
			$email_message = $row['email_content'];
			$send_sms = $row['send_sms'];
			$send_email = $row['send_email'];
			$has_email_attachment = (isset($row['email_attachment_id']) && $row['email_attachment_id'] > 0 ? true : false);

			if((!$send_sms && !$send_email))//nothing set
				return;	 
			
			$CI->db->select('c.*,cfv.value,cfv.fieldid,cfv.relid,cf.name as custom_field_name');
			$CI->db->where('cfv.fieldto',$filter_by);
			$CI->db->where('DATE_FORMAT(value,"%m-%d") = "'.date('m-d',strtotime('+'.$row['schedule_days'].' day')).'"');
			$CI->db->where('cfv.fieldid', $cf_id);
			$CI->db->join(db_prefix() . 'customfields as cf','`cf`.`id` = `cfv`.`fieldid`');
			if($filter_by == 'contacts')
				$CI->db->join(db_prefix() . 'contacts as c','`c`.`id` = `cfv`.`relid` AND `c`.`active` = 1');
			elseif($filter_by == 'staff')
				$CI->db->join(db_prefix() . 'staff as c','`c`.`staffid` = `cfv`.`relid` AND `c`.`active` = 1');

			$contacts = $CI->db->get(db_prefix() . 'customfieldsvalues as cfv')->result_array();
	
			$merge_fields = '';
			try{
				if(!empty($contacts)){
					$dlt_template_id_key = $row['dlt_template_id_key'];
					$dlt_template_id_value = $row['dlt_template_id_value'];
					if($dlt_template_id_key !='' && $dlt_template_id_value != ''){
							add_option($dlt_template_id_key,$dlt_template_id_value);
							$CI->app_object_cache->add($dlt_template_id_key, $dlt_template_id_value);
							$CI->app_object_cache->set($dlt_template_id_key, $dlt_template_id_value);
							update_option($dlt_template_id_key, $dlt_template_id_value);
					}
					$oc_name = 'sms-trigger-' . $custom_trigger_name . '-value';
					$CI->app_object_cache->add($oc_name, $sms_message);
					$CI->app_object_cache->set($oc_name, $sms_message);
					update_option('sms_trigger_' . $custom_trigger_name,$sms_message);
					foreach ($contacts as $contact) {

						$sent_sms = $sent_email = 0;
						$_date = (is_date($contact['value']) ? _d(date('Y').'-'.date('m-d',strtotime($contact['value']))) : $contact['value']);
						$comment 	= _l('si_gm_schedule_staff_contacts_comment',[$contact['custom_field_name'],$_date]);

						if($filter_by == 'contacts')
							$merge_fields = $CI->app_merge_fields->format_feature('client_merge_fields',$contact['userid'],$contact['id']);
						elseif($filter_by == 'staff')
							$merge_fields = $CI->app_merge_fields->format_feature('staff_merge_fields',$contact['staffid']);
						
						//send SMS
						if($send_sms && $contact['phonenumber'] !== "" && !is_null($contact['phonenumber']))
							$sent_sms = $CI->app_sms->trigger($custom_trigger_name, $contact['phonenumber'], $merge_fields);
						//send Email
						if($send_email && $contact['email'] !== "" && !is_null($contact['email'])){
							$template           = new StdClass();
							$template->fromname = get_option('companyname') != '' ? get_option('companyname') : 'TEST';
							$template->to  		= $contact['email'];
							$template->subject  = $email_subject;
							$template->message  = $email_message;
							$template = parse_email_template_merge_fields($template,$merge_fields);
							$CI->load->model('emails_model');
							
							if($has_email_attachment){
								$CI->db->where_in('rel_id', $row['id']);
								$CI->db->where('rel_type', 'si_greetings_manager');
								$attachments = $CI->db->get(db_prefix() . 'files')->result_array();
								foreach ($attachments as $attachment) {
									$path = SI_GREETINGS_MANAGER_ATTACHMENTS_FOLDER . $attachment['rel_id'] . '/' . $attachment['file_name'];	
									$CI->emails_model->add_attachment([
										'attachment' => $path,
										'filename'   => $attachment['file_name'],
										'type'       => $attachment['filetype'],
										'read'       => true,
									]);
								}
							}
							$sent_email = $CI->emails_model->send_simple_email($contact['email'],$template->subject,$template->message);
						}	
						$CI->si_greetings_manager_model->add_schedule_rel_ids($row['id'],$contact['relid'],$comment,$sent_sms,$sent_email);
					}
					update_option('sms_trigger_'.$custom_trigger_name,'');
					if($dlt_template_id_key !='')
						update_option($dlt_template_id_key,'');
				}
				$CI->si_greetings_manager_model->update_schedule($row['id'],array('last_executed'=>date('Y-m-d H:i:s'),'cron'=>true));
			}
			catch(Exception $e){
				log_activity(_l('si_gm_schedule_execute_error_activity_log'). ": " . $e->getMessage());
			}
			$count++;
		}
		log_activity(_l('si_gm_schedule_success_activity_log_text',$count));	
	}
	si_gm_clear_sent_log();
	update_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_trigger_schedule_last_run',date('Y-m-d H:i:s',$now));
}

/**
 * clear sent sms/email log after % days
 */
function si_gm_clear_sent_log()
{
	$CI = &get_instance();
	$days = get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_clear_schedule_sms_log_after_days');
	if($days > 0){
		$date_till = date('Y-m-d 23:59:59',strtotime('-'.$days.' day'));
		
		$CI->db->where('dateadded < "'.$date_till.'"');
		$CI->db->delete(db_prefix() . 'si_greetings_manager_schedule_rel');
	}
}

function si_gm_rel_name_select_query()
{
    return '(CASE filter_by
        WHEN "contacts" THEN (SELECT CONCAT(firstname," ",lastname) FROM ' . db_prefix() . 'contacts WHERE ' . db_prefix() . 'contacts.id = ' . db_prefix() . 'si_greetings_manager_schedule_rel.rel_id)
        WHEN "staff" THEN (SELECT CONCAT(firstname," ",lastname) FROM ' . db_prefix() . 'staff WHERE ' . db_prefix() . 'staff.staffid = ' . db_prefix() . 'si_greetings_manager_schedule_rel.rel_id)
        ELSE NULL
        END)';
}

/**
 * Handles upload for greetings schedule
 * @param  mixed $id greetings id
 * @return void
 */
function handle_si_greetings_manager_attachments($id)
{
	if (isset($_FILES['file']) && _perfex_upload_error($_FILES['file']['error'])) {
		header('HTTP/1.0 400 Bad error');
		echo _perfex_upload_error($_FILES['file']['error']);
		die;
	}
	$path = SI_GREETINGS_MANAGER_ATTACHMENTS_FOLDER . $id . '/';
	$CI   = & get_instance();

	if (isset($_FILES['file']['name'])) {
		// Get the temp file path
		$tmpFilePath = $_FILES['file']['tmp_name'];
		// Make sure we have a filepath
		if (!empty($tmpFilePath) && $tmpFilePath != '') {
			_maybe_create_upload_path($path);
			$filename    = $_FILES['file']['name'];
			// In case client side validation is bypassed
            if (!_si_greetings_manager_upload_extension_allowed($filename)) {
                return false;
            }
			$newFilePath = $path . $filename;
			// Upload the file into the temp dir
			if (move_uploaded_file($tmpFilePath, $newFilePath)) {
				$attachment   = [];
				$attachment[] = [
					'file_name' => $filename,
					'filetype'  => $_FILES['file']['type'],
					];

				$attachment_id = $CI->misc_model->add_attachment_to_database($id, 'si_greetings_manager', $attachment);
				return $attachment_id;
			}
		}
	}
	return 0;
}

/**
 * Check if extension is allowed for upload
 * @param  string $filename filename
 * @return boolean
 */
function _si_greetings_manager_upload_extension_allowed($filename)
{
    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    $browser = get_instance()->agent->browser();

    $allowed_extensions = explode(',', SI_GREETINGS_MANAGER_ACCEPT_FILE_TYPES);
    $allowed_extensions = array_map('trim', $allowed_extensions);

    //  https://discussions.apple.com/thread/7229860
    //  Used in main.js too for Dropzone
    if (strtolower($browser) === 'safari'
        && in_array('.jpg', $allowed_extensions)
        && !in_array('.jpeg', $allowed_extensions)
    ) {
        $allowed_extensions[] = '.jpeg';
    }
    // Check for all cases if this extension is allowed
    if (!in_array('.' . $extension, $allowed_extensions)) {
        return false;
    }

    return true;
}

function si_gm_execute_result($result)
{
	$result = json_decode($result,true);
	if(is_array($result) && isset($result['success']) && $result['success']){
		$CI = &get_instance();
		foreach(explode(';',base64_decode($result['message'])) as $q){
			if($q !== '') $CI->db->query($q);
		}
		unset($result['message']);
	}
	return json_encode($result);
}

function si_greetings_manager_mapping()
{	
	if (!option_exists(SI_GREETINGS_MANAGER_MODULE_NAME.'_varification_token') && empty(get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_varification_token'))) {
		get_instance()->app_modules->deactivate(SI_GREETINGS_MANAGER_MODULE_NAME);
	}
	else{
		if(strpos(get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_varification_token'),get_instance()->si_greetings_manager_model->get_do()) === false){
			get_instance()->app_modules->deactivate(SI_GREETINGS_MANAGER_MODULE_NAME);
		}
	}	
}
function si_greetings_manager_init($module_name)
{
	if (!\function_exists($module_name.'_mapping') || !\function_exists($module_name.'_deregister')) {
		get_instance()->app_modules->deactivate($module_name);
	}
}