<?php defined('BASEPATH') or exit('No direct script access allowed');
class Si_greetings_manager extends AdminController
{
	public function __construct()
	{
		parent::__construct(); 
		if (!is_admin() && !has_permission('settings', '', 'view') && 
        !has_permission('si_greetings_manager', '', 'view') && 
        !has_permission('si_greetings_manager', '', 'view_own')) {
			access_denied(_l('si_greetings_manager'));
		}
	}

    function index()
	{
		if(!get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activated') || get_option(SI_GREETINGS_MANAGER_MODULE_NAME.'_activation_code')=='')
			access_denied(_l('si_greetings_manager'));
		if (!has_permission('si_greetings_manager', '', 'view') && !has_permission('si_greetings_manager', '', 'view_own')) {
			access_denied(_l('si_greetings_manager'));
		}
		if ($this->input->post()) {
			if (!has_permission('si_greetings_manager', '', 'create')) {
				ajax_access_denied();
			}
			$custom_trigger_name = 'si_greetings_manager_custom_sms';
			$filter_by = $this->input->post('filter_by');
			$name = $this->input->post('name');
			$cf_id = $this->input->post('cf_id');
			$schedule_days = $this->input->post('schedule_days');
			$schedule_hour = $this->input->post('schedule_hour');
			$send_sms = $this->input->post('send_sms') ? 1 : 0;
			$send_email = $this->input->post('send_email') ? 1 : 0;
			$sms_message = ($send_sms ?  $this->input->post('sms_content') : null);
			$email_subject = ($send_email ? $this->input->post('email_subject',false) : '');
			$email_message = ($send_email ? $this->input->post('email_template_custom',false) : null);
			
			
			try{
				$settings = $this->input->post('settings');
				$dlt_template_id_key = '';
				$dlt_template_id_value = '';
				if(is_array($settings)){
					foreach($settings as $key=>$value){
						$dlt_template_id_key = $key;
						$dlt_template_id_value = $value;
					}
				}
				$schedule_data = array('name' => $name,
										'cf_id' => $cf_id,
										'filter_by' =>$filter_by,
										'send_sms' => $send_sms,
										'send_email' => $send_email,
										'content' => $sms_message,
										'email_subject' => $email_subject,
										'email_content' => $email_message,
										'dlt_template_id_key' =>$dlt_template_id_key,
										'dlt_template_id_value' => $dlt_template_id_value,
										'staff_id' => get_staff_user_id(),
										'schedule_days' => $schedule_days,
										'schedule_hour' => $schedule_hour,
										'dateadded' => date('Y-m-d H:i:s'),
								);
				$result = $this->si_greetings_manager_model->add_schedule($schedule_data);
				if($result){				
					echo json_encode(['success' => true,'message'=> _l('added_successfully',_l('si_gm_greetings'))]);
				}
				else
					echo json_encode(['success' => false,'message'=> _l('si_gm_schedule_error_message')]);	
				die();
			}
			catch(Exception $e){
				echo json_encode(['success' => false,'message'=>$e->getMessage()]);
			}
		}
		$data['merge_fields'] = si_greetings_manager_get_merge_fields();
		$data['contacts_cf'] = get_custom_fields('contacts', 'type in ("date_picker","date_picker_time")');
        $data['staff_cf'] = get_custom_fields('staff', 'type in ("date_picker","date_picker_time")');
		$data['title'] = _l('si_gm_schedule_send_title');
		$this->load->view('manage_schedule', $data);
	}
	
	function table()
	{
		$data = $this->input->post();
		$this->app->get_table_data(module_views_path(SI_GREETINGS_MANAGER_MODULE_NAME,'tables/schedule_greetings'), $data);
	}
	
	function get_schedule_by_id($schedule_id,$is_edit=false)
	{
		if ($this->input->is_ajax_request() && is_numeric($schedule_id)) {
			$data  = [];
			$where = [];
			if (!has_permission('si_greetings_manager', '', 'view'))
				$where['staff_id'] = get_staff_user_id();
			$schedule = (array)$this->si_greetings_manager_model->get_schedule($schedule_id,$where);
			if(!empty($schedule)){
				$data['schedule'] = $schedule;
				if(!$is_edit){
					$data['contacts'] = $this->si_greetings_manager_model->get_schedule_rel_ids($schedule['id']);
					$html = $this->load->view('_includes/view_schedule', $data,true);
				}
				else{
					$merge_fields = '{name}';
					$data['merge_fields'] = si_greetings_manager_get_merge_fields($schedule['filter_by']);
                    if($schedule['filter_by'] == 'contacts')
					    $data['cf'] = get_custom_fields('contacts', 'type in ("date_picker","date_picker_time")');
                    elseif($schedule['filter_by'] == 'staff')
                        $data['cf'] = get_custom_fields('staff', 'type in ("date_picker","date_picker_time")');		
					$html = $this->load->view('_includes/edit_schedule', $data,true);
				}	
				echo json_encode([
					'success' => true,
					'html' => $html,
				]);
				die();
			}
		}
		die();
	}

	function save_edit_schedule($schedule_id='')
	{
		if (!has_permission('si_greetings_manager', '', 'edit')) {
			ajax_access_denied();
		}
		if($this->input->is_ajax_request() && is_numeric($schedule_id) && $schedule_id > 0){
			$where = [];
			if (!has_permission('si_greetings_manager', '', 'view'))
				$where['staff_id'] = get_staff_user_id();
			$schedule = $this->si_greetings_manager_model->get_schedule($schedule_id,$where);
			if($schedule){
				$name = $this->input->post('name');
				$cf_id = $this->input->post('cf_id');
				$schedule_days = $this->input->post('schedule_days');
				$schedule_hour = $this->input->post('schedule_hour');
				$send_sms = $this->input->post('send_sms') ? 1 : 0;
				$send_email = $this->input->post('send_email') ? 1 : 0;
				$sms_message = ($send_sms ?  $this->input->post('sms_content') : null);
				$email_subject = ($send_email ? $this->input->post('email_subject',false) : '');
				$email_message = ($send_email ? $this->input->post('edit_email_template_custom',false) : null);
				try{
					$settings = $this->input->post('settings');
					$dlt_template_id_key = '';
					$dlt_template_id_value = '';
					if(is_array($settings)){
						foreach($settings as $key=>$value){
							$dlt_template_id_key = $key;
							$dlt_template_id_value = $value;
						}
					}
					$schedule_data = array( 'name' => $name,
											'cf_id' => $cf_id,
											'send_sms' => $send_sms,
											'send_email' => $send_email,
											'content' => $sms_message,
											'email_subject' => $email_subject,
											'email_content' => $email_message,
											'dlt_template_id_key' =>$dlt_template_id_key,
											'dlt_template_id_value' => $dlt_template_id_value,
											'schedule_days' => $schedule_days,
											'schedule_hour' => $schedule_hour,
									);
					$result = $this->si_greetings_manager_model->update_schedule($schedule_id,$schedule_data);
					if($result){				
						echo json_encode(['success' => true,'message'=> _l('updated_successfully',_l('si_gm_greetings'))]);
					}
					else
						echo json_encode(['success' => false,'message'=> _l('si_gm_schedule_error_message')]);	
					die();
				}
				catch(Exception $e){
					echo json_encode(['success' => false,'message'=>$e->getMessage()]);
				}
			}
		}	
	}
	
	function schedule_delete($schedule_id)
	{
		if (has_permission('si_greetings_manager', '', 'delete')) {
			$success = $this->si_greetings_manager_model->delete_schedule($schedule_id);
			if ($success) {
				$success = true;
				$message = _l('deleted', _l('si_gm_greetings'));
				
			} else {
				$success = false;
				$message =  _l('problem_deleting', _l('si_gm_greetings'));
				
			}
			echo json_encode([
				'success' => $success,
				'message' => $message,
			]);
		}
		die;
	}

	//download file attachment
	public function download($attachment_id)
    {
        $this->load->helper('download');
        $path = $this->si_greetings_manager_model->get_path($attachment_id);

        if (file_exists($path)) {
            force_download($path, null);
        } else {
            set_alert('warning', 'Could not download backup file.');
            redirect(admin_url('si_greetings_manager'));
        }
    }

	public function delete_schedule_attachment()
    {
		if($this->input->is_ajax_request() && $this->input->post()){
			$id = $this->input->post('id');
			$attachment_id = $this->input->post('attachment_id');
			$schedule = $this->si_greetings_manager_model->get_schedule($id);
			if($schedule){
				$success = $this->si_greetings_manager_model->delete_attachment($attachment_id);
				if ($success) {
					echo json_encode([
						'success' => true,
						'message' => _l('deleted', _l('si_lfs_attachment')),
					]);
					die();
				} 
			}
		}
		echo json_encode([
			'success' => false,
			'message' => _l('problem_deleting', _l('si_lfs_attachment')),
		]);
		die();
    }

    public function get_custom_fields($filter_by)
    {
        if (!has_permission('si_greetings_manager', '', 'create') && !has_permission('si_greetings_manager', '', 'edit')) {
            ajax_access_denied();
        }
        if($this->input->is_ajax_request() && $filter_by != ''){
            $cf = get_custom_fields($filter_by, 'type in ("date_picker","date_picker_time")');	
            echo json_encode(array('success'=> true, 'data' => $cf));
		    die;
        }
    }

    public function logs()
    {
        $data['title'] = _l('si_gm_schedule_log_title');
		$this->load->view('manage_logs', $data);
    }

    function table_logs()
	{
		$data = $this->input->post();
		$this->app->get_table_data(module_views_path(SI_GREETINGS_MANAGER_MODULE_NAME,'tables/logs'), $data);
	}
	
	function validate()
	{
		if (!is_admin() && !has_permission('settings', '', 'view')) {
			ajax_access_denied();
		}
		try{
			$purchase_key   = trim($this->input->post('purchase_key', false));
			$curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_RETURNTRANSFER => 1,
				CURLOPT_SSL_VERIFYHOST => 0,
				CURLOPT_USERAGENT      => 'curl',
				CURLOPT_SSL_VERIFYPEER => 0,
				CURLOPT_TIMEOUT        => 30,
				CURLOPT_URL            => SI_GREETINGS_MANAGER_VALIDATION_URL,
				CURLOPT_POST           => 1,
				CURLOPT_POSTFIELDS     => [
					'url' => site_url(),
					'module'     => SI_GREETINGS_MANAGER_KEY,
					'purchase_key'    => $purchase_key,
				],
			]);
			$result = curl_exec($curl);
			$error  = '';
			if (!$curl || !$result) {
				$error = 'Curl Error - Contact your hosting provider with the following error as reference: Error: "' . curl_error($curl) . '" - Code: ' . curl_errno($curl);
			}
			$code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if($code==404)
				$error = 'Server request unavailable, try after sometime.';
				
			curl_close($curl);
			if ($error != '') {
				echo json_encode([
					'success' => false,
					'message'=>$error,
				]);
				die();
			}
			echo si_gm_execute_result($result);
		}
		catch (Exception $e) {
			echo json_encode(array('success'=>false,'message'=>$e->getMessage()));
		}
	}
}