(function($) {
"use strict";

init_editor('.tinymce-si', { urlconverter_callback: merge_field_format_url, 'max-height': 100 });

var SiScheduleSMSServerParams = {};
initDataTable('.table-si-greetings-manager-schedule', admin_url+'si_greetings_manager/table', undefined, undefined,
	SiScheduleSMSServerParams, [0, "asc"]);

var SiLogServerParams = {};
var SiLogIndex = $('.table-si-greetings-manager-logs').find('th.date-created').index();
initDataTable('.table-si-greetings-manager-logs', admin_url+'si_greetings_manager/table_logs', undefined, undefined,
	SiLogServerParams, [SiLogIndex, "desc"]);	

appValidateForm($("#si_greetings_manager_schedule_form"), {
	name: 'required',
	cf_id: 'required',
	sms_content: {'required':function () {
						return ($("input[name='send_sms']").is(":checked") ? true : false);
				   },
				  'maxlength':5000},
	email_template_custom: {'required':function () {
					return ($("input[name='send_email']").is(":checked") ? true : false);
			   },
	},		   			  
	schedule_days: 'required',
	schedule_hour: 'required',
	file:{extension: accept_file_types},
},manage_schedule_send_form);

function manage_schedule_send_form()
{
	if(!$("input[name='send_sms']").is(":checked") && !$("input[name='send_email']").is(":checked")){
		alert(select_sms_or_email);
		return false;
	}
		
	tinymce.triggerSave();
	var ubtn = $('#si_greetings_manager_send');
	var form = $('#si_greetings_manager_schedule_form')[0];
	var data = new FormData(form);
	var url = form.action;
	ubtn.html($('#si_greetings_manager_send_wrapper').data('wait-text'));
	ubtn.addClass('disabled');
	
	$.ajax({
        type: 'POST',
        data: data,
        mimeType: "multipart/form-data",
        contentType: false,
        cache: false,
        processData: false,
        url: url
    })
	.done(function(response){
		response=JSON.parse(response);
		if(response['success']){
			ubtn.removeClass('disabled');
			ubtn.html($('#si_greetings_manager_send_wrapper').data('original-text'));
			alert_float('success', response['message']);
			$('.table-si-greetings-manager-schedule').DataTable().ajax.reload();
		}else{
			ubtn.removeClass('disabled');
			ubtn.html($('#si_greetings_manager_send_wrapper').data('original-text'));
			alert_float('danger', response['message']);
		}	
	}).fail(function(response){
		alert_float('danger', response.responseText);
		ubtn.removeClass('disabled');
		ubtn.html($('#si_greetings_manager_send_wrapper').data('original-text'));
	});

}
$('input[name="filter_by"]').on('change', function() {
	var filter_by = $(this).val();
	$('.div_merge_field').hide();
	$('#div_merge_field_'+filter_by).show();
	requestGet('si_greetings_manager/get_custom_fields/' + filter_by).done(function(response) {
		response = JSON.parse(response);
		if (response.success === true || response.success == 'true') { 
			var toAppend = '';
			$.each(response.data, function(i, item) {
			toAppend += '<option value="'+item.id+'">'+item.name+'</option>';
			});
			$('#cf_id').find('option').not(':first').remove();
			$('#cf_id').append(toAppend);
			$('#cf_id').selectpicker('refresh');
		}
		else{
			$('#cf_id').find('option').not(':first').remove();
			$('#cf_id').selectpicker('refresh');
		}
	}).fail(function(data) {
		alert_float('danger', data.responseText);
	});
});
$(document).ready(function() {
	$('.div_merge_field').hide();
	$('#div_merge_field_contacts').show();
});
$('#si_greetings_manager_clear').on('click', function() {
	$('#cf_id').selectpicker('val','').selectpicker('refresh');
	$('#div_dlt_template').find('input.form-control').val('');
	$('select,textarea,input').parents('.form-group').removeClass('has-error');
	$('p.text-danger').hide();
});
$(document).on('click','.si_greetings_manager_schedule_delete',function(e){
	e.preventDefault();
	requestGet('si_greetings_manager/schedule_delete/' + $(this).data('id')).done(function(response) {
		response = JSON.parse(response);
		if (response.success === true || response.success == 'true') { 
			alert_float('success', response.message);
			$('.table-si-greetings-manager-schedule').DataTable().ajax.reload();
		}
		else{
			alert_float('warning', response.message); 
		}
	}).fail(function(data) {
		alert_float('danger', data.responseText);
	});
});

$(document).on('click','#si_greetings_manager_btn_for_edit',function(e){
	appValidateForm($("#si_greetings_manager_edit_schedule_form"), {
		name: 'required',
		cf_id: 'required',
		sms_content: {'required':function () {
					return ($("#si_greetings_manager_edit_schedule_form input[name='send_sms']").is(":checked") ? true : false);
			},
			'maxlength':5000},
		edit_email_template_custom: {'required':function () {
				return ($("#si_greetings_manager_edit_schedule_form input[name='send_email']").is(":checked") ? true : false);
		},
		},
		schedule_days: 'required',
		schedule_hour: 'required',
		file:{extension: accept_file_types},
	});
	
	tinymce.triggerSave();
	var ubtn = $('#si_greetings_manager_btn_for_edit');
	var _form = $('#si_greetings_manager_edit_schedule_form');
	if (_form.length && !_form.validate().checkForm())
		return false;
	var form = $('#si_greetings_manager_edit_schedule_form')[0];
	var data = new FormData(form);
	var url = form.action;
	ubtn.html($('#si_greetings_manager_edit_send_wrapper').data('wait-text'));
	ubtn.addClass('disabled');
	$.ajax({
        type: 'POST',
        data: data,
        mimeType: "multipart/form-data",
        contentType: false,
        cache: false,
        processData: false,
        url: url
    }).done(function(response){
		response=JSON.parse(response);
		if(response['success']){
			ubtn.removeClass('disabled');
			ubtn.html($('#si_greetings_manager_edit_send_wrapper').data('original-text'));
			alert_float('success', response['message']);
			$('#si_greetings_manager_view_schedule_modal').modal('hide');
			$('.table-si-greetings-manager-schedule').DataTable().ajax.reload();
		}else{
			ubtn.removeClass('disabled');
			ubtn.html($('#si_greetings_manager_edit_send_wrapper').data('original-text'));
			alert_float('danger', response['message']);
		}	
	}).fail(function(response){
		alert_float('danger', response.responseText);
		ubtn.removeClass('disabled');
		ubtn.html($('#si_greetings_manager_edit_send_wrapper').data('original-text'));
	});
});	
// Remove the tinymce email edit editor
 $("body").on("hidden.bs.modal", '#si_greetings_manager_view_schedule_modal', function() {
	tinyMCE.remove('.tinymce-si-edit');
});
})(jQuery);	

function view_schedule_modal(id) {
	requestGetJSON('si_greetings_manager/get_schedule_by_id/' + id).done(function(response) {
		var schedule_modal = $('#si_greetings_manager_view_schedule_modal');
		schedule_modal.find('#div_greetings_view_schedule').html(response.html);
		schedule_modal.modal('show');
		$('#si_greetings_manager_btn_for_edit').hide();
	});
}
function edit_schedule_modal(id) {

	requestGetJSON('si_greetings_manager/get_schedule_by_id/' + id +'/1').done(function(response) {
		var schedule_modal = $('#si_greetings_manager_view_schedule_modal');
		schedule_modal.find('#div_greetings_view_schedule').html(response.html);
		schedule_modal.modal('show');
		$('#si_greetings_manager_btn_for_edit').show();
		init_selectpicker();
		init_datepicker();
		init_editor('.tinymce-si-edit', { 
			urlconverter_callback: merge_field_format_url, 
			'max-height': 100 
		});
		tinymce.triggerSave();
	});
}
function delete_schedule_attachment(id,attachment_id)
{
	var data = {id:id,attachment_id:attachment_id};
	$.post(admin_url+'si_greetings_manager/delete_schedule_attachment',data).done(function(response){
		response=JSON.parse(response);
		if(response['success']){
			alert_float('success', response['message']);
			$('#si_greetings_manager_view_schedule_modal').modal('hide');
			edit_schedule_modal(id);
		}else{
			alert_float('danger', response['message']);
		}	
	}).fail(function(response){
		alert_float('danger', response.responseText);
	});
}