<?php

defined('BASEPATH') || exit('No direct script access allowed');

use WpOrg\Requests\Requests as Webhooks_Requests;
/*
 * Define module name
 * Module Name Must be in CAPITAL LETTERS
 */

if (!defined('WEBHOOKS_MODULE')) {
    define('WEBHOOKS_MODULE', 'saas/webhooks');
}

/*
 *  Load module helper file
 */
$CI = &get_instance();
$CI->load->helper(SUPERADMIN_MODULE . '/webhooks');
$CI->load->helper(SUPERADMIN_MODULE . '/request_webhook');

/*
 *  Inject css file for webhooks module
 */
hooks()->add_action('app_admin_head', 'sb_webhooks_add_head_components');
function sb_webhooks_add_head_components()
{
    //check module is enable or not (refer install.php)
    if (get_instance()->app_modules->is_active('saas')) {
        $CI = &get_instance();
        echo '<link href="' . module_dir_url('saas', 'assets/css/webhooks.css') . '?v=' . $CI->app_scripts->core_version() . '"  rel="stylesheet" type="text/css" />';
        echo '<link href="' . module_dir_url('saas', 'assets/css/tribute.css') . '?v=' . $CI->app_scripts->core_version() . '"  rel="stylesheet" type="text/css" />';
        echo '<link href="' . module_dir_url('saas', 'assets/css/prism.css') . '?v=' . $CI->app_scripts->core_version() . '"  rel="stylesheet" type="text/css" />';
    }
}

/*
 *  Inject Javascript file for webhooks module
 */
hooks()->add_action('app_admin_footer', 'sb_webhooks_load_js');
function sb_webhooks_load_js()
{
    if (get_instance()->app_modules->is_active('saas')) {
        $CI = &get_instance();
        $CI->load->library('App_merge_fields');
        $merge_fields = $CI->app_merge_fields->all();
        echo '<script>var merge_fields = ' . json_encode($merge_fields) . '</script>';
        echo '<script src="' . module_dir_url('saas', 'assets/js/underscore-min.js') . '?v=' . $CI->app_scripts->core_version() . '"></script>';
        echo '<script src="' . module_dir_url('saas', 'assets/js/tribute.min.js') . '?v=' . $CI->app_scripts->core_version() . '"></script>';
        echo '<script src="' . module_dir_url('saas', 'assets/js/webhooks.js') . '?v=' . $CI->app_scripts->core_version() . '"></script>';
        echo '<script src="' . module_dir_url('saas', 'assets/js/prism.js') . '?v=' . $CI->app_scripts->core_version() . '"></script>';
    }
}

//inject permissions Feature and Capabilities for webhooks module
hooks()->add_filter('staff_permissions', 'sb_webhooks_module_permissions_for_staff');
function sb_webhooks_module_permissions_for_staff($permissions)
{
    $viewGlobalName =
        _l('permission_view') . '(' . _l('permission_global') . ')';
    $allPermissionsArray = [
        'view'   => $viewGlobalName,
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];
    $permissions['WEBHOOKS'] = [
        'name'         => _l('webhooks'),
        'capabilities' => $allPermissionsArray,
    ];

    return $permissions;
}

// Inject sidebar menu and links for webhooks module
hooks()->add_action('admin_init', 'sb_webhooks_module_init_menu_items');
function sb_webhooks_module_init_menu_items()
{
    $CI = &get_instance();
    if (staff_can('view', 'webhooks')) {
        $CI->app_menu->add_sidebar_menu_item('webhooks', [
            'slug'     => 'webhooks',
            'name'     => _l('webhooks'),
            'icon'     => 'fa fa-handshake-o menu-icon fa-duotone fa-circle-nodes',
            'href'     => 'webhooks',
            'position' => 30,
        ]);
    }

    if (staff_can('view', 'webhooks')) {
        $CI->app_menu->add_sidebar_children_item('webhooks', [
            'slug'     => 'webhooks',
            'name'     => _l('webhooks'),
            'icon'     => 'fa fa-compress',
            'href'     => admin_url(WEBHOOKS_MODULE),
            'position' => 1,
        ]);
    }

    if (staff_can('view', 'webhooks')) {
        $CI->app_menu->add_sidebar_children_item('webhooks', [
            'slug'     => 'webhook_log',
            'name'     => _l('webhook_log'),
            'icon'     => 'fa fa-history',
            'href'     => admin_url(WEBHOOKS_MODULE . '/logs'),
            'position' => 2,
        ]);
    }

    if (staff_can('view', 'webhooks')) {
        $CI->app_menu->add_sidebar_children_item('webhooks', [
            'slug' => 'webhooks_cron',
            'name' => _l('webhooks_cron'),
            'icon' => 'fa fa-fan',
            'href' => admin_url('settings?group=webhooks'),
            'position' => 3,
        ]);
    }

    if (staff_can('view', 'webhooks')) {
        if (CTL_PERFEX_VERSION) {
            $CI->app->add_settings_section_child('other', 'webhooks', [
                'name'     => _l('webhooks_cron_job'),
                'view'     => SUPERADMIN_MODULE . '/settings/webhooks_cron_job',
                'icon'     => 'fa-solid fa-microchip',
                'position' => 2,
            ]);
        } else {
            $CI->app_tabs->add_settings_tab('webhooks', [
                'name'     => _l('webhooks_cron_job'),
                'view'     => 'webhooks/settings/webhooks_cron_job',
                'icon'     => 'fa-solid fa-microchip',
                'position' => 50,
            ]);
        }
    }
}

/* Contact webhooks : Start */
// Add new contact
hooks()->add_action('contact_created', 'sb_wbhk_contact_added_hook');
function sb_wbhk_contact_added_hook($contactID)
{
    $CI        = &get_instance();
    $tableData = new stdClass();
    $tableData->ContactData = $CI->clients_model->get_contact($contactID);
    $tableData->ClientData = $CI->clients_model->get($tableData->ContactData->userid);

    sb_call_webhook($tableData, 'client', 'add', $tableData->ContactData->userid, $contactID);
}

// Update contact
hooks()->add_action('contact_updated', 'sb_wbhk_contact_updated_hook');
function sb_wbhk_contact_updated_hook($contactID)
{
    $CI        = &get_instance();
    $tableData = new stdClass();
    $tableData->ContactData = $CI->clients_model->get_contact($contactID);
    $tableData->ClientData = $CI->clients_model->get($tableData->ContactData->userid);

    sb_call_webhook($tableData, 'client', 'edit', $tableData->ContactData->userid, $contactID);
}

// Delete contact
hooks()->add_action('before_delete_contact', 'sb_wbhk_contact_deleted_hook');
function sb_wbhk_contact_deleted_hook($contactID)
{
    $CI        = &get_instance();
    $tableData = new stdClass();
    $tableData->ContactData = $CI->clients_model->get_contact($contactID);
    $tableData->ClientData = $CI->clients_model->get($tableData->ContactData->userid);

    sb_call_webhook($tableData, 'client', 'delete', $tableData->ContactData->userid, $contactID);
}
/* Contact webhooks : End */

/* Lead webhooks : Start */
// Add new lead
hooks()->add_action('lead_created', 'sb_wbhk_lead_added_hook');
function sb_wbhk_lead_added_hook($leadID)
{
    $CI        = &get_instance();
    //if lead created from web to lead form then leadid will be array
    if (is_array($leadID)) {
        $leadID = $leadID['lead_id'];
    }
    $tableData = $CI->leads_model->get($leadID);
    sb_call_webhook($tableData, 'leads', 'add', $leadID);
}

// Lead status changed
hooks()->add_action('lead_status_changed', 'sb_wbhk_lead_status_changed_hook');
function sb_wbhk_lead_status_changed_hook($lead)
{
    $CI        = &get_instance();
    $tableData = $CI->leads_model->get($lead['lead_id']);
    sb_call_webhook($tableData, 'leads', 'status_change', $lead['lead_id']);
}

// Delete lead
hooks()->add_action('before_lead_deleted', 'sb_wbhk_lead_deleted_hook');
function sb_wbhk_lead_deleted_hook($leadID)
{
    $CI        = &get_instance();
    $tableData = $CI->leads_model->get($leadID);
    sb_call_webhook($tableData, 'leads', 'delete', $leadID);
}
/* Lead webhooks : End */

/* Invoice webhooks : Start */
// Add new invoice
hooks()->add_action('after_invoice_added', 'sb_wbhk_invoice_added_hook');
function sb_wbhk_invoice_added_hook($invoiceID)
{
    $CI        = &get_instance();
    $tableData = $CI->invoices_model->get($invoiceID);
    sb_call_webhook($tableData, 'invoice', 'add', $invoiceID);
}

// Update invoice
hooks()->add_action('invoice_updated', 'sb_wbhk_invoice_updated_hook');
function sb_wbhk_invoice_updated_hook($invoice)
{
    $CI        = &get_instance();
    $tableData = $CI->invoices_model->get($invoice['id']);
    sb_call_webhook($tableData, 'invoice', 'edit', $invoice['id']);
}

// Delete invoice
hooks()->add_action('before_invoice_deleted', 'sb_wbhk_invoice_deleted_hook');
function sb_wbhk_invoice_deleted_hook($invoiceID)
{
    $CI        = &get_instance();
    $tableData = $CI->invoices_model->get($invoiceID);
    sb_call_webhook($tableData, 'invoice', 'delete', $invoiceID);
}

hooks()->add_action('after_recurring_invoice_created', 'sb_wbhk_invoice_recurring_hook');
function sb_wbhk_invoice_recurring_hook($invoice)
{
    if (!empty($invoice['new_invoice_id'])) {
        $CI        = &get_instance();
        $tableData = $CI->invoices_model->get($invoice['new_invoice_id']);
        sb_call_webhook($tableData, 'invoice', 'recurring_create', $invoice['new_invoice_id']);
    }
}
/* Invoice webhooks : End */

/* Task webhooks : Start */
// Add new task
hooks()->add_action('after_add_task', 'sb_wbhk_task_added_hook');
function sb_wbhk_task_added_hook($taskId)
{
    $CI        = &get_instance();
    $tableData = $CI->tasks_model->get($taskId);
    sb_call_webhook($tableData, 'tasks', 'add', $taskId);
}

// Update task
hooks()->add_action('after_update_task', 'sb_wbhk_task_updated_hook');
function sb_wbhk_task_updated_hook($taskId)
{
    $CI        = &get_instance();
    $tableData = $CI->tasks_model->get($taskId);
    sb_call_webhook($tableData, 'tasks', 'edit', $taskId);
}

// Delete task

/* Task webhooks : End */

/* Projects webhooks : Start */
// Add new project
hooks()->add_action('after_add_project', 'sb_wbhk_project_added_hook');
function sb_wbhk_project_added_hook($projectId)
{
    $CI        = &get_instance();
    $tableData = $CI->projects_model->get($projectId);
    sb_call_webhook($tableData, 'projects', 'add', $projectId);
}

// Update project
hooks()->add_action('after_update_project', 'sb_wbhk_project_updated_hook');
function sb_wbhk_project_updated_hook($projectId)
{
    $CI        = &get_instance();
    $tableData = $CI->projects_model->get($projectId);
    sb_call_webhook($tableData, 'projects', 'edit', $projectId);
}

// Delete project
hooks()->add_action('before_project_deleted', 'sb_wbhk_project_deleted_hook');
function sb_wbhk_project_deleted_hook($projectId)
{
    $CI        = &get_instance();
    $tableData = $CI->projects_model->get($projectId);
    sb_call_webhook($tableData, 'projects', 'delete', $projectId);
}
/* Projects webhooks : End */

/* Proposal webhooks : Start */
// Add new proposal
hooks()->add_action('proposal_created', 'sb_wbhk_proposal_added_hook');
function sb_wbhk_proposal_added_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'add', $proposalId);
}

// Update proposal
hooks()->add_action('after_proposal_updated', 'sb_wbhk_proposal_updated_hook');
function sb_wbhk_proposal_updated_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'edit', $proposalId);
}

// Delete proposal
hooks()->add_action('before_proposal_deleted', 'sb_wbhk_proposal_deleted_hook');
function sb_wbhk_proposal_deleted_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'delete', $proposalId);
}

// Accept proposal
hooks()->add_action('proposal_accepted', 'sb_wbhk_proposal_accepted_hook');
function sb_wbhk_proposal_accepted_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'accept', $proposalId);
}

// Decline proposal
hooks()->add_action('proposal_declined', 'sb_wbhk_proposal_declined_hook');
function sb_wbhk_proposal_declined_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'decline', $proposalId);
}

// Sent proposal
hooks()->add_action('proposal_sent', 'sb_wbhk_proposal_sent_hook');
function sb_wbhk_proposal_sent_hook($proposalId)
{
    $CI        = &get_instance();
    $tableData = $CI->proposals_model->get($proposalId);
    sb_call_webhook($tableData, 'proposals', 'sent', $proposalId);
}
/* Proposal webhooks : End */

/* Ticket webhooks : Start */
// Add new ticket
hooks()->add_action('ticket_created', 'sb_wbhk_ticket_added_hook');
function sb_wbhk_ticket_added_hook($ticketId)
{
    $CI        = &get_instance();
    $tableData = $CI->tickets_model->get($ticketId);
    sb_call_webhook($tableData, 'ticket', 'add', $ticketId);
}

// Update ticket
hooks()->add_action('ticket_settings_updated', 'sb_wbhk_ticket_updated_hook');
function sb_wbhk_ticket_updated_hook($ticket)
{
    $CI        = &get_instance();
    $tableData = $CI->tickets_model->get($ticket['ticket_id']);
    sb_call_webhook($tableData, 'ticket', 'edit', $ticket['ticket_id']);
}

// Ticket status changed
hooks()->add_action('after_ticket_status_changed', 'sb_wbhk_ticket_status_changed_hook');
function sb_wbhk_ticket_status_changed_hook($ticket)
{
    $CI        = &get_instance();
    $tableData = $CI->tickets_model->get($ticket['id']);
    sb_call_webhook($tableData, 'ticket', 'status_change', $ticket['id']);
}

// Delete ticket
hooks()->add_action('before_ticket_deleted', 'sb_wbhk_ticket_deleted_hook');
function sb_wbhk_ticket_deleted_hook($ticketID)
{
    $CI        = &get_instance();
    $tableData = $CI->tickets_model->get($ticketID);
    sb_call_webhook($tableData, 'ticket', 'delete', $ticketID);
}
/* Ticket webhooks : End */

/* Payment webhooks : Start */
// Add new payment
hooks()->add_action('after_payment_added', 'sb_wbhk_payment_added_hook');
function sb_wbhk_payment_added_hook($paymentId)
{
    $CI        = &get_instance();
    $tableData = $CI->payments_model->get($paymentId);
    sb_call_webhook($tableData, 'invoice_payments', 'add', $tableData->invoiceid, $paymentId);
}

// Update payment
hooks()->add_action('after_payment_updated', 'sb_wbhk_payment_updated_hook');
function sb_wbhk_payment_updated_hook($payment)
{
    $CI        = &get_instance();
    $tableData = $CI->payments_model->get($payment['id']);
    sb_call_webhook($tableData, 'invoice_payments', 'edit', $tableData->invoiceid, $payment['id']);
}

// Delete payment
hooks()->add_action('before_payment_deleted', 'sb_wbhk_payment_deleted_hook');
function sb_wbhk_payment_deleted_hook($payment)
{
    $CI        = &get_instance();
    $tableData = $CI->payments_model->get($payment['paymentid']);
    sb_call_webhook($tableData, 'invoice_payments', 'delete', $tableData->invoiceid, $payment['paymentid']);
}
/* Payment webhooks : End */

/* Staff webhooks : Start */
// Add new staff
hooks()->add_action('staff_member_created', 'sb_wbhk_staff_added_hook');
function sb_wbhk_staff_added_hook($staffid)
{
    $CI        = &get_instance();
    $tableData = $CI->staff_model->get($staffid);
    sb_call_webhook($tableData, 'staff', 'add', $staffid);
}

// Update staff
hooks()->add_action('staff_member_updated', 'sb_wbhk_staff_updated_hook');
function sb_wbhk_staff_updated_hook($staffid)
{
    $CI        = &get_instance();
    $tableData = $CI->staff_model->get($staffid);
    sb_call_webhook($tableData, 'staff', 'edit', $staffid);
}

// Delete staff
hooks()->add_action('before_delete_staff_member', 'sb_wbhk_staff_deleted_hook');
function sb_wbhk_staff_deleted_hook($staff)
{
    $CI        = &get_instance();
    $tableData = $CI->staff_model->get($staff['id']);
    sb_call_webhook($tableData, 'staff', 'delete', $staff['id']);
}
/* Staff webhooks : End */

/* Contracts webhooks : Start */
// Add new contract
hooks()->add_action('after_contract_added', 'sb_wbhk_contract_added_hook');
function sb_wbhk_contract_added_hook($contractID)
{
    $CI        = &get_instance();
    $tableData = $CI->contracts_model->get($contractID);
    sb_call_webhook($tableData, 'contract', 'add', $contractID);
}

// Update contract
hooks()->add_action('after_contract_updated', 'sb_wbhk_contract_updated_hook');
function sb_wbhk_contract_updated_hook($contractID)
{
    $CI        = &get_instance();
    $tableData = $CI->contracts_model->get($contractID);
    sb_call_webhook($tableData, 'contract', 'edit', $contractID);
}

// Delete contract
hooks()->add_action('before_contract_deleted', 'sb_wbhk_contract_deleted_hook');
function sb_wbhk_contract_deleted_hook($contractID)
{
    $CI        = &get_instance();
    $tableData = $CI->contracts_model->get($contractID);
    sb_call_webhook($tableData, 'contract', 'delete', $contractID);
}
/* Contracts webhooks : End */

/* Estimates webhooks : Start */
// Add new estimate
hooks()->add_action('after_estimate_added', 'sb_wbhk_estimate_added_hook');
function sb_wbhk_estimate_added_hook($estimateID)
{
    $CI        = &get_instance();
    $tableData = $CI->estimates_model->get($estimateID);
    sb_call_webhook($tableData, 'estimate', 'add', $estimateID);
}

// Update estimate
hooks()->add_action('after_estimate_updated', 'sb_wbhk_estimate_updated_hook');
function sb_wbhk_estimate_updated_hook($estimateID)
{
    $CI        = &get_instance();
    $tableData = $CI->estimates_model->get($estimateID);
    sb_call_webhook($tableData, 'estimate', 'edit', $estimateID);
}

// Delete estimate
hooks()->add_action('before_estimate_deleted', 'sb_wbhk_estimate_deleted_hook');
function sb_wbhk_estimate_deleted_hook($estimateID)
{
    $CI        = &get_instance();
    $tableData = $CI->estimates_model->get($estimateID);
    sb_call_webhook($tableData, 'estimate', 'delete', $estimateID);
}
/* Estimates webhooks : End */
// Update calendar event
hooks()->add_filter('event_update_data', 'sb_wbhk_calendar_event_updated_hook', 0, 2);
function sb_wbhk_calendar_event_updated_hook($eventData, $eventID)
{
    $CI        = &get_instance();
    $eventData['end'] = $eventData['end'] ?? "";
    sb_call_webhook((object)$eventData, 'event', 'edit', $eventID);
    return $eventData;
}
/* Calendar event webhooks : End */

hooks()->add_action('after_expense_added', 'sb_wbhk_expense_added_hook');
function sb_wbhk_expense_added_hook($expenseID)
{
    $CI        = &get_instance();
    $CI->load->model('expenses_model');
    $tableData = $CI->expenses_model->get($expenseID);
    sb_call_webhook($tableData, 'expenses', 'add', $expenseID);
}

hooks()->add_action('expense_updated', 'sb_wbhk_expense_updated_hook');
function sb_wbhk_expense_updated_hook($expense)
{
    $CI        = &get_instance();
    $CI->load->model('expenses_model');
    $tableData = $CI->expenses_model->get($expense['id']);
    sb_call_webhook($tableData, 'expenses', 'edit', $expense['id']);
}

hooks()->add_action('after_recurring_expense_created', 'sb_wbhk_expense_recurring_hook');
function sb_wbhk_expense_recurring_hook($expense)
{
    if (!empty($expense['new_expense_id'])) {
        $CI        = &get_instance();
        $CI->load->model('expenses_model');
        $tableData = $CI->expenses_model->get($expense['new_expense_id']);
        sb_call_webhook($tableData, 'expenses', 'recurring_create', $expense['new_expense_id']);
    }
}

hooks()->add_filter("staff_merge_fields", function ($fields, $data) {
    $fields['{staff_phonenumber}'] = $data['staff']->phonenumber;
    return $fields;
}, 10, 2);

hooks()->add_filter("available_merge_fields", function ($available) {
    $i = 0;
    foreach ($available as $fields) {
        $f = 0;
        // Fix for merge fields as custom fields not matching the names
        foreach ($fields as $key => $_fields) {
            if ($key == "staff") {
                $format = [
                    'base_name' => "staff_merge_fields",
                    'file'      => "merge_fields/staff_merge_fields",
                ];
                array_push($available[$i][$key], [
                    'name'      => "Staff Phone",
                    'key'       => '{staff_phonenumber}',
                    'available' => $available[$i][$key][$f]['available'],
                    'format'    => $format,
                ]);
            }
            if ($key == "client") {

                $format = [
                    'base_name' => "client_merge_fields",
                    'file'      => "merge_fields/client_merge_fields",
                ];

                $custom_fields = get_custom_fields("contacts", [], true);

                foreach ($custom_fields as $field) {
                    array_push($available[$i][$key], [
                        'name'      => $field['name'],
                        'key'       => '{' . $field['slug'] . '}',
                        'available' => $available[$i][$key][$f]['available'],
                        'format'    => $format,
                    ]);
                }
            }
            $f++;
        }
        $i++;
    }

    return $available;
});

hooks()->add_action('before_start_render_dashboard_content', function () {
    $CI        = &get_instance();
    if (get_option("webhook_cron_has_run_from_cli") == 0 && !empty($CI->db->count_all_results("scheduled_webhooks"))) {
        $html = '<div class="col-md-12"><div class="alert alert-warning" font-medium>';
        $html .= 'You\'ve added webhook with scheduled time that requires cron job setup to work properly.';
        $html .= '<br />Please follow the cron <a href="https://help.perfexcrm.com/setup-cron-job/" target="_blank">setup guide</a> in order all features to work well.';
        $html .= '</div></div>';
    }

    echo $html ?? '';
});
