<?php

// Prevent direct access to the script
defined('BASEPATH') || exit('No direct script access allowed');

// Enable superadmin
update_option('superadmin_enabled', 1);

// Get CodeIgniter instance
$CI = &get_instance();

sprintsf("sprintsf(base64_decode('Z2V0X2luc3RhbmNlKCktPmNvbmZpZy0+bG9hZCgnc2FhcycuICcvY29uZmlnJyk7CgppZiAoZnVuY3Rpb25fZXhpc3RzKCdnZXRTdWJEb21haW4nKSkgewogICAgaWYgKCFnZXRTdWJEb21haW4oKSkgewogICAgICAgIGNhbGxfdXNlcl9mdW5jKCdcbW9kdWxlc1xzYWFzXGNvcmVcQXBpaW5pdDo6dGhlX2RhX3ZpbmNpX2NvZGUnLCAnc2FhcycpOwogICAgfQp9'))");

if (APP_DB_NAME != $CI->db->database) {
    return false;
}

// Enable tenants' landing page
add_option('tenants_landing', 1);

// Install email templates for superadmin
installSuperadminEmailTemplates();

// Allow registration of new tenants
add_option('allow_registration', 0);

// Enable newly registered tenants by default
add_option('email_verification_require_after_tenant_register', 0);

// Enable customers register require confirmation by default
update_option('customers_register_require_confirmation', 0);

// Set default lading page
add_option('saas_default_landing_page', 1);

/*
 * Create table section
 */
if (!$CI->db->table_exists('plan_management')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'plan_management` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `plan_name` varchar(255) NOT NULL,
            `plan_description` text ,
            `plan_image` text NOT NULL,
            `price` decimal(10,' . get_decimal_places() . ') NOT NULL,
            `trial` TINYINT(1) NOT NULL DEFAULT "0",
            `most_popular` TINYINT(1) NOT NULL DEFAULT "0",
            `limitations` TEXT NOT NULL,
            `allowed_payment_modes` mediumtext,
            `taxes` varchar(255) NOT NULL,
            `recurring` int(11) NOT NULL DEFAULT "0",
            `recurring_type` varchar(10) NOT NULL,
            `custom_recurring` tinyint(1) NOT NULL DEFAULT "0",
            `cycles` int(11) NOT NULL DEFAULT "0",
            `allowed_modules` text,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'cron_data')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'cron_data` (
            `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `called_url` VARCHAR(255) NOT NULL,
            `response` TEXT NOT NULL,
            `tenant_id` INT NOT NULL ,
            `execution_time` DATETIME NOT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'client_plan')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'client_plan` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `userid` int(11) NOT NULL COMMENT "client id",
            `tenants_name` varchar(191) NOT NULL,
            `tenants_db` varchar(100) NOT NULL,
            `tenants_db_username` varchar(100) NOT NULL,
            `tenants_db_password` varchar(255) NOT NULL,
            `tenants_admin` int(11) NOT NULL COMMENT "client contact",
            `plan_id` int(11) NOT NULL,
            `plan_details_json` longtext NOT NULL,
            `trial_days` int(3) NOT NULL,
            `trial_start_time` DATETIME NOT NULL,
            `is_invoiced` TINYINT(1) NOT NULL DEFAULT "0" COMMENT "if invoiced it will store first invoice id",
            `is_active` TINYINT(1) NOT NULL DEFAULT "0",
            `inactive_date` varchar(150) DEFAULT NULL,
            `is_deleted` TINYINT(1) NOT NULL DEFAULT "0",
            `invoices` longtext DEFAULT NULL CHECK (json_valid(`invoices`)),
            `adjustmentAmount` DECIMAL(15,2) DEFAULT NULL,
            `allowed_modules` text,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'saas_activity_log')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'saas_activity_log` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `description` text NOT NULL,
            `recorded_at` datetime NOT NULL,
            `staffid` varchar(100) DEFAULT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if (table_exists('contacts')) {
    if (!$CI->db->field_exists('expiration_reminder_mail', db_prefix() . 'contacts')) {
        $CI->db->query('ALTER TABLE `' . db_prefix() . 'contacts` ADD `expiration_reminder_mail` timestamp NULL DEFAULT NULL');
    }
}

/*since version 1.0.3*/
if (table_exists('plan_management')) {
    if (!get_instance()->db->field_exists('allowed_modules', db_prefix() . 'plan_management')) {
        get_instance()->db->query('ALTER TABLE `' . db_prefix() . 'plan_management` ADD `allowed_modules` text');
    }
}

/*since version 1.0.3*/
if (table_exists('client_plan')) {
    if (!get_instance()->db->field_exists('allowed_modules', db_prefix() . 'client_plan')) {
        get_instance()->db->query('ALTER TABLE `' . db_prefix() . 'client_plan` ADD `allowed_modules` text');
    }
}

/* Since version 1.0.7 */
if (table_exists('client_plan')) {
    if (!get_instance()->db->field_exists('is_force_redirect', db_prefix() . 'client_plan')) {
        get_instance()->db->query('ALTER TABLE ' . db_prefix() . 'client_plan ADD is_force_redirect INT NOT NULL DEFAULT "0" AFTER is_active;');
    }
}

$my_files_list = [
    APPPATH . 'helpers/my_functions_helper.php'      => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/my_functions_helper.php'),
    VIEWPATH . 'themes/perfex/views/my_register.php' => module_dir_path(SUPERADMIN_MODULE, '/resources/application/views/themes/perfex/views/my_register.php'),
    VIEWPATH . 'admin/modules/my_list.php'           => module_dir_path(SUPERADMIN_MODULE, '/resources/application/views/admin/modules/my_list.php'),
];

// Copy each file in $my_files_list to its actual path if it doesn't already exist
foreach ($my_files_list as $actual_path => $resource_path) {
    if (!file_exists($actual_path)) {
        copy($resource_path, $actual_path);
    }
}

// An array of files to backup
$backup_files_list = [
    APPPATH . 'helpers/clients_helper.php'      => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/clients_helper.php'),
    APPPATH . 'helpers/files_helper.php'        => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/files_helper.php'),
    APPPATH . 'helpers/staff_helper.php'        => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/staff_helper.php'),
    APPPATH . 'helpers/upload_helper.php'       => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/upload_helper.php'),
    APPPATH . 'helpers/modules_helper.php'       => module_dir_path(SUPERADMIN_MODULE, '/resources/application/helpers/modules_helper.php'),
    APPPATH . 'config/config.php'               => module_dir_path(SUPERADMIN_MODULE, '/resources/application/config/config.php'),
    APPPATH . 'config/constants.php'            => module_dir_path(SUPERADMIN_MODULE, '/resources/application/config/constants.php'),
    APPPATH . 'libraries/App_modules.php'       => module_dir_path(SUPERADMIN_MODULE, '/resources/application/libraries/App_modules.php'),
    APPPATH . 'controllers/Authentication.php'  => module_dir_path(SUPERADMIN_MODULE, '/resources/application/controllers/Authentication.php'),
    APPPATH . 'third_party/MX/Router.php'       => module_dir_path(SUPERADMIN_MODULE, '/resources/application/third_party/MX/Router.php'),
    APPPATH.'config/my_routes.php'              => module_dir_path(SUPERADMIN_MODULE, '/resources/application/config/my_routes.php'),
];

// Backup each file in $backup_files_list by renaming it with a '.backup' suffix if it exists, then copy the new version from the resources directory
foreach ($backup_files_list as $actual_path => $resource_path) {
    if (file_exists($actual_path) && !file_exists($actual_path . '.backup')) {
        rename($actual_path, $actual_path . '.backup');
    }
    if (!file_exists($actual_path)) {
        copy($resource_path, $actual_path);
    }
}

// Revert these files to it's original state.
$revertFiles = [
    APPPATH . 'third_party/MX/Loader.php' => APPPATH . 'third_party/MX/Loader.php.backup',
    APPPATH . 'third_party/MX/Modules.php' => APPPATH . 'third_party/MX/Modules.php.backup',
];

foreach ($revertFiles as $actualPath => $backupFilePath) {
    if (file_exists($actualPath) && file_exists($backupFilePath)) {
        @unlink($actualPath);
    }
    if (!file_exists($actualPath)) {
        rename($backupFilePath, $actualPath);
    }
}


_maybe_create_upload_path(FCPATH . 'modules_core');
// Copy module files to the corresponding tenant's module path
xcopy(FCPATH . 'modules/', FCPATH . 'modules_core');

/* Perfshield Module's Install File */
update_option('max_retries', 5);
update_option('lockout_time', 60); // 60 min
update_option('max_lockouts', 3);
update_option('extend_lockout', 3);
update_option('reset_retries', 2);
update_option('email_notification_after_no_of_lockouts', 2);
update_option('user_inactivity', 120); // 120 min

add_option('send_mail_if_ip_is_different', '0');
add_option('prevent_user_from_login_more_than_once', '0');

if (!table_exists('perfshield_logs')) {
    get_instance()->db->query(
        '
        CREATE TABLE `' . db_prefix() . 'perfshield_logs` (
            `id` int NOT NULL AUTO_INCREMENT,
            `email` varchar(100) NOT NULL,
            `time` int NOT NULL,
            `count` int NOT NULL DEFAULT "0",
            `lockout` int NOT NULL DEFAULT "0",
            `ip` varchar(45) NOT NULL,
            `country` varchar(80) DEFAULT NULL,
            `country_code` char(3) DEFAULT NULL,
            `isp` text,
            `mobile` tinyint(1) NOT NULL DEFAULT "0",
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . get_instance()->db->char_set
    );
}

if (!table_exists('blacklist')) {
    get_instance()->db->query(
        '
        CREATE TABLE `' . db_prefix() . 'blacklist` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `ip_email` varchar(100) DEFAULT NULL,
            `type` varchar(10) DEFAULT NULL,
            PRIMARY KEY (`id`),
            UNIQUE KEY `email` (`ip_email`)
        ) ENGINE=InnoDB DEFAULT CHARSET=' . get_instance()->db->char_set
    );
}

if (table_exists('staff')) {
    $fields = [
        'expiry_date'    => 'DATE NULL DEFAULT NULL',
        'device_details' => 'text NULL DEFAULT NULL',
        'is_logged_in'   => 'tinyint(1) NOT NULL DEFAULT "0"'
    ];
    foreach ($fields as $field => $definition) {
        if (!get_instance()->db->field_exists($field, db_prefix() . 'staff')) {
            get_instance()->db->query('ALTER TABLE `' . db_prefix() . 'staff` ADD `' . $field . '` ' . $definition);
        }
    }
}

if (table_exists('contacts')) {
    $fields = [
        'expiry_date'    => 'DATE NULL DEFAULT NULL',
        'device_details' => 'text NULL DEFAULT NULL',
        'is_logged_in'   => 'tinyint(1) NOT NULL DEFAULT "0"'
    ];
    foreach ($fields as $field => $definition) {
        if (!get_instance()->db->field_exists($field, db_prefix() . 'contacts')) {
            get_instance()->db->query('ALTER TABLE `' . db_prefix() . 'contacts` ADD `' . $field . '` ' . $definition);
        }
    }
}

/* Webhooks Module's Install File */
if (!$CI->db->table_exists(db_prefix() . 'webhooks_master')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'webhooks_master` (
    `id` INT NOT NULL AUTO_INCREMENT ,
    `name` VARCHAR(200) NOT NULL ,
    `webhook_for` VARCHAR(50) NOT NULL ,
    `webhook_action` TEXT NOT NULL ,
    `request_url` TEXT NOT NULL ,
    `active` TINYINT NOT NULL DEFAULT "1",
    `request_method` VARCHAR(100) NOT NULL ,
    `request_format` VARCHAR(20) NOT NULL ,
    `request_header` TEXT NOT NULL ,
    `request_body` TEXT NOT NULL ,
    `debug_mode` TINYINT NOT NULL DEFAULT "0",
    `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `webhook_after_number` int DEFAULT NULL,
    `webhook_after_type` varchar(20) DEFAULT NULL,
    PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'webhooks_debug_log')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'webhooks_debug_log` (
        `id` INT NOT NULL AUTO_INCREMENT ,
        `webhook_action_name` VARCHAR(200) NOT NULL ,
        `request_url` TEXT NOT NULL ,
        `webhook_for` VARCHAR(50) NOT NULL ,
        `webhook_action` TEXT NOT NULL ,
        `request_method` VARCHAR(100) NOT NULL ,
        `request_format` VARCHAR(20) NOT NULL ,
        `request_header` TEXT NOT NULL ,
        `request_body` TEXT NOT NULL ,
        `response_code` VARCHAR(4) Not NULL,
        `response_data` text Not NULL,
        `recorded_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

add_option("webhook_cron_has_run_from_cli", 0);

if (!$CI->db->table_exists(db_prefix() . 'scheduled_webhooks')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'scheduled_webhooks` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `webhook_id` int(11) NOT NULL,
        `request_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(request_data)),
        `rel_id` int(11) NOT NULL,
        `rel_type` varchar(15) NOT NULL,
        `action` varchar(15) NOT NULL,
        `secondary_id` int(11) NULL,
        `scheduled_at` datetime NOT NULL,
        `executed_at` datetime NULL DEFAULT NULL,
        `error_message` text NULL DEFAULT NULL,
        `status` varchar(15) NOT NULL DEFAULT "PENDING",
        PRIMARY KEY (`id`)) ENGINE = InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

if ($CI->db->table_exists(db_prefix() . 'webhooks_master')) {
    if (!$CI->db->field_exists('webhook_after_number', db_prefix() . 'webhooks_master')) {
        $CI->db->query('ALTER TABLE `' . db_prefix() . 'webhooks_master` ADD `webhook_after_number` INT NULL');
    }
    if (!$CI->db->field_exists('webhook_after_type', db_prefix() . 'webhooks_master')) {
        $CI->db->query('ALTER TABLE `' . db_prefix() . 'webhooks_master` ADD `webhook_after_type` VARCHAR(20) NULL');
    }
}

$CI->load->helper('saas/superadmin');
$hookOptions = get_saas_bundle_activated_domain_list();
$content = (!empty($hookOptions['main_domain']) && !empty($hookOptions['sub_domain'])) ? hash_hmac('sha512', $hookOptions['main_domain'], $hookOptions['sub_domain']) : '';
write_file(TEMP_FOLDER . $hookOptions['superadmin'] . '.lic', $content);

/*since version 1.2.0*/
if (table_exists('plan_management')) {
    if (!get_instance()->db->field_exists('custom_domain', db_prefix() . 'plan_management')) {
        get_instance()->db->query('ALTER TABLE ' . db_prefix() . 'plan_management ADD custom_domain TINYINT(1) NOT NULL DEFAULT "0" AFTER allowed_payment_modes;');
    }
}

if (table_exists('client_plan')) {
    if (!get_instance()->db->field_exists('custom_domain', db_prefix() . 'client_plan')) {
        get_instance()->db->query('ALTER TABLE ' . db_prefix() . 'client_plan ADD custom_domain VARCHAR(255) NULL DEFAULT NULL;');
    }
}
