<?php

defined('BASEPATH') || exit('No direct script access allowed');

if (\PHP_SAPI !== 'cli' || !defined('STDIN')) {
    if (!function_exists('getMyBaseUrl')) {
        function getMyBaseUrl()
        {
            $scheme = $_SERVER['REQUEST_SCHEME'] ?? $_SERVER['HTTP_X_FORWARDED_PROTO'] ?? (('on' == strtolower($_SERVER['HTTPS'])) ? 'https' : 'http');

            return $scheme."://{$_SERVER['HTTP_HOST']}".str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
        }
    }

    $currentURL = current_url();
    $params     = $_SERVER['QUERY_STRING'];
    $url    = $currentURL . '?' . $params;
    $parsed = parse_url($url);
    $pathSegments = explode('/', trim($parsed['path'], '/'));

    $baseUrl = getMyBaseUrl();
    if($pathSegments[0] == "ws" && !empty($pathSegments[1]) && validate_tenant($pathSegments[1])) {
        $basePath = implode('/', array_slice($pathSegments, 0, 2));
        $baseUrl = $parsed['scheme'] . '://' . $parsed['host'] . '/' . $basePath . '/';

    }
    (!defined('APP_URL')) ? define('APP_URL', $baseUrl) : '';
    // (!defined('APP_URL')) ? define('APP_URL', getMyBaseUrl()) : '';
    $config['base_url'] = $baseUrl;
} else {
    $config['base_url'] = '';
}
